/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SubscriptionStatus {
    REQUESTED,
    ACTIVE,
    ERROR,
    OFF,
    NULL;


    public static SubscriptionStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("requested".equals(codeString)) {
            return REQUESTED;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        if ("off".equals(codeString)) {
            return OFF;
        }
        throw new FHIRException("Unknown SubscriptionStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REQUESTED: {
                return "requested";
            }
            case ACTIVE: {
                return "active";
            }
            case ERROR: {
                return "error";
            }
            case OFF: {
                return "off";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/subscription-status";
    }

    public String getDefinition() {
        switch (this) {
            case REQUESTED: {
                return "The client has requested the subscription, and the server has not yet set it up.";
            }
            case ACTIVE: {
                return "The subscription is active.";
            }
            case ERROR: {
                return "The server has an error executing the notification.";
            }
            case OFF: {
                return "Too many errors have occurred or the subscription has expired.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REQUESTED: {
                return "Requested";
            }
            case ACTIVE: {
                return "Active";
            }
            case ERROR: {
                return "Error";
            }
            case OFF: {
                return "Off";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

