/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ExtraSecurityRoleType;

public class ExtraSecurityRoleTypeEnumFactory
implements EnumFactory<ExtraSecurityRoleType> {
    @Override
    public ExtraSecurityRoleType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("authserver".equals(codeString)) {
            return ExtraSecurityRoleType.AUTHSERVER;
        }
        if ("datacollector".equals(codeString)) {
            return ExtraSecurityRoleType.DATACOLLECTOR;
        }
        if ("dataprocessor".equals(codeString)) {
            return ExtraSecurityRoleType.DATAPROCESSOR;
        }
        if ("datasubject".equals(codeString)) {
            return ExtraSecurityRoleType.DATASUBJECT;
        }
        throw new IllegalArgumentException("Unknown ExtraSecurityRoleType code '" + codeString + "'");
    }

    @Override
    public String toCode(ExtraSecurityRoleType code) {
        if (code == ExtraSecurityRoleType.NULL) {
            return null;
        }
        if (code == ExtraSecurityRoleType.AUTHSERVER) {
            return "authserver";
        }
        if (code == ExtraSecurityRoleType.DATACOLLECTOR) {
            return "datacollector";
        }
        if (code == ExtraSecurityRoleType.DATAPROCESSOR) {
            return "dataprocessor";
        }
        if (code == ExtraSecurityRoleType.DATASUBJECT) {
            return "datasubject";
        }
        return "?";
    }

    @Override
    public String toSystem(ExtraSecurityRoleType code) {
        return code.getSystem();
    }
}

