/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CompositionStatus;

public class CompositionStatusEnumFactory
implements EnumFactory<CompositionStatus> {
    @Override
    public CompositionStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preliminary".equals(codeString)) {
            return CompositionStatus.PRELIMINARY;
        }
        if ("final".equals(codeString)) {
            return CompositionStatus.FINAL;
        }
        if ("amended".equals(codeString)) {
            return CompositionStatus.AMENDED;
        }
        if ("entered-in-error".equals(codeString)) {
            return CompositionStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown CompositionStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(CompositionStatus code) {
        if (code == CompositionStatus.NULL) {
            return null;
        }
        if (code == CompositionStatus.PRELIMINARY) {
            return "preliminary";
        }
        if (code == CompositionStatus.FINAL) {
            return "final";
        }
        if (code == CompositionStatus.AMENDED) {
            return "amended";
        }
        if (code == CompositionStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(CompositionStatus code) {
        return code.getSystem();
    }
}

