/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Location", profile="http://hl7.org/fhir/Profile/Location")
public class Location
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique code or number identifying the location to its users", formalDefinition="Unique code or number identifying the location to its users.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | suspended | inactive", formalDefinition="The status property covers the general availability of the resource, not the current value which may be covered by the operationStatus, or by a schedule/slots if they are configured for the location.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-status")
    protected Enumeration<LocationStatus> status;
    @Child(name="operationalStatus", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Operational status of the location (typically only for a bed/room)", formalDefinition="The Operational status covers operation values most relevant to beds (but can also apply to rooms/units/chair/etc such as an isolation unit/dialisys chair). This typically covers concepts such as contamination, housekeeping and other activities\u00a0like maintenance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-0116")
    protected Coding operationalStatus;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the location as used by humans", formalDefinition="Name of the location as used by humans. Does not need to be unique.")
    protected StringType name;
    @Child(name="alias", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of\u00a0alternate names that the location is known as, or was known as in the past", formalDefinition="A list of\u00a0alternate names that the location is known as, or was known as in the past.")
    protected List<StringType> alias;
    @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional details about the location that could be displayed as further information to identify the location beyond its name", formalDefinition="Description of the Location, which helps in finding or referencing the place.")
    protected StringType description;
    @Child(name="mode", type={CodeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="instance | kind", formalDefinition="Indicates whether a resource instance represents a specific location or a class of locations.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-mode")
    protected Enumeration<LocationMode> mode;
    @Child(name="type", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of function performed", formalDefinition="Indicates the type of function performed at the location.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ServiceDeliveryLocationRoleType")
    protected CodeableConcept type;
    @Child(name="telecom", type={ContactPoint.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact details of the location", formalDefinition="The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Physical location", formalDefinition="Physical location.")
    protected Address address;
    @Child(name="physicalType", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Physical form of the location", formalDefinition="Physical form of the location, e.g. building, room, vehicle, road.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-physical-type")
    protected CodeableConcept physicalType;
    @Child(name="position", type={}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The absolute geographic location", formalDefinition="The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).")
    protected LocationPositionComponent position;
    @Child(name="managingOrganization", type={Organization.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization responsible for provisioning and upkeep", formalDefinition="The organization responsible for the provisioning and upkeep of the location.")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="partOf", type={Location.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Another Location this one is physically part of", formalDefinition="Another Location which this Location is physically part of.")
    protected Reference partOf;
    protected Location partOfTarget;
    @Child(name="endpoint", type={Endpoint.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for the location", formalDefinition="Technical endpoints providing access to services operated for the location.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    private static final long serialVersionUID = -1603579027L;
    @SearchParamDefinition(name="identifier", path="Location.identifier", description="An identifier for the location", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="partof", path="Location.partOf", description="A location of which this location is a part", type="reference", target={Location.class})
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("Location:partof").toLocked();
    @SearchParamDefinition(name="near-distance", path="Location.position", description="A distance quantity to limit the near search to locations within a specific distance\n\nRequires the near parameter to also be included", type="quantity")
    public static final String SP_NEAR_DISTANCE = "near-distance";
    public static final QuantityClientParam NEAR_DISTANCE = new QuantityClientParam("near-distance");
    @SearchParamDefinition(name="address", path="Location.address", description="A (part of the) address of the location", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-state", path="Location.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="operational-status", path="Location.operationalStatus", description="Searches for locations (typically bed/room) that have an operational status (e.g. contaminated, housekeeping)", type="token")
    public static final String SP_OPERATIONAL_STATUS = "operational-status";
    public static final TokenClientParam OPERATIONAL_STATUS = new TokenClientParam("operational-status");
    @SearchParamDefinition(name="type", path="Location.type", description="A code for the type of location", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="address-postalcode", path="Location.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Location.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="endpoint", path="Location.endpoint", description="Technical endpoints providing access to services operated for the location", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("Location:endpoint").toLocked();
    @SearchParamDefinition(name="organization", path="Location.managingOrganization", description="Searches for locations that are managed by the provided organization", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Location:organization").toLocked();
    @SearchParamDefinition(name="name", path="Location.name | Location.alias", description="A portion of the location's name or alias", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address-use", path="Location.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="near", path="Location.position", description="The coordinates expressed as [latitude]:[longitude] (using the WGS84 datum, see notes) to find locations near to (servers may search using a square rather than a circle for efficiency)\n\nRequires the near-distance parameter to be provided also", type="token")
    public static final String SP_NEAR = "near";
    public static final TokenClientParam NEAR = new TokenClientParam("near");
    @SearchParamDefinition(name="address-city", path="Location.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="status", path="Location.status", description="Searches for locations with a specific kind of status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Location setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Location addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<LocationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<LocationStatus>(new LocationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Location setStatusElement(Enumeration<LocationStatus> value) {
        this.status = value;
        return this;
    }

    public LocationStatus getStatus() {
        return this.status == null ? null : (LocationStatus)((Object)this.status.getValue());
    }

    public Location setStatus(LocationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<LocationStatus>(new LocationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Coding getOperationalStatus() {
        if (this.operationalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.operationalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.operationalStatus = new Coding();
            }
        }
        return this.operationalStatus;
    }

    public boolean hasOperationalStatus() {
        return this.operationalStatus != null && !this.operationalStatus.isEmpty();
    }

    public Location setOperationalStatus(Coding value) {
        this.operationalStatus = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Location setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Location setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public Location setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public Location addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Location setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Location setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Enumeration<LocationMode> getModeElement() {
        if (this.mode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.mode");
            }
            if (Configuration.doAutoCreate()) {
                this.mode = new Enumeration<LocationMode>(new LocationModeEnumFactory());
            }
        }
        return this.mode;
    }

    public boolean hasModeElement() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public boolean hasMode() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public Location setModeElement(Enumeration<LocationMode> value) {
        this.mode = value;
        return this;
    }

    public LocationMode getMode() {
        return this.mode == null ? null : (LocationMode)((Object)this.mode.getValue());
    }

    public Location setMode(LocationMode value) {
        if (value == null) {
            this.mode = null;
        } else {
            if (this.mode == null) {
                this.mode = new Enumeration<LocationMode>(new LocationModeEnumFactory());
            }
            this.mode.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Location setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Location setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Location addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Address getAddress() {
        if (this.address == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.address");
            }
            if (Configuration.doAutoCreate()) {
                this.address = new Address();
            }
        }
        return this.address;
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public Location setAddress(Address value) {
        this.address = value;
        return this;
    }

    public CodeableConcept getPhysicalType() {
        if (this.physicalType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.physicalType");
            }
            if (Configuration.doAutoCreate()) {
                this.physicalType = new CodeableConcept();
            }
        }
        return this.physicalType;
    }

    public boolean hasPhysicalType() {
        return this.physicalType != null && !this.physicalType.isEmpty();
    }

    public Location setPhysicalType(CodeableConcept value) {
        this.physicalType = value;
        return this;
    }

    public LocationPositionComponent getPosition() {
        if (this.position == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.position");
            }
            if (Configuration.doAutoCreate()) {
                this.position = new LocationPositionComponent();
            }
        }
        return this.position;
    }

    public boolean hasPosition() {
        return this.position != null && !this.position.isEmpty();
    }

    public Location setPosition(LocationPositionComponent value) {
        this.position = value;
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Location setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public Location setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Location setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Location getPartOfTarget() {
        if (this.partOfTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOfTarget = new Location();
            }
        }
        return this.partOfTarget;
    }

    public Location setPartOfTarget(Location value) {
        this.partOfTarget = value;
        return this;
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public Location setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public Location addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique code or number identifying the location to its users.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status property covers the general availability of the resource, not the current value which may be covered by the operationStatus, or by a schedule/slots if they are configured for the location.", 0, 1, this.status));
        children.add(new Property("operationalStatus", "Coding", "The Operational status covers operation values most relevant to beds (but can also apply to rooms/units/chair/etc such as an isolation unit/dialisys chair). This typically covers concepts such as contamination, housekeeping and other activities\u00a0like maintenance.", 0, 1, this.operationalStatus));
        children.add(new Property(SP_NAME, "string", "Name of the location as used by humans. Does not need to be unique.", 0, 1, this.name));
        children.add(new Property("alias", "string", "A list of\u00a0alternate names that the location is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("description", "string", "Description of the Location, which helps in finding or referencing the place.", 0, 1, this.description));
        children.add(new Property("mode", "code", "Indicates whether a resource instance represents a specific location or a class of locations.", 0, 1, this.mode));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Indicates the type of function performed at the location.", 0, 1, this.type));
        children.add(new Property("telecom", "ContactPoint", "The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property(SP_ADDRESS, "Address", "Physical location.", 0, 1, this.address));
        children.add(new Property("physicalType", "CodeableConcept", "Physical form of the location, e.g. building, room, vehicle, road.", 0, 1, this.physicalType));
        children.add(new Property("position", "", "The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).", 0, 1, this.position));
        children.add(new Property("managingOrganization", "Reference(Organization)", "The organization responsible for the provisioning and upkeep of the location.", 0, 1, this.managingOrganization));
        children.add(new Property("partOf", "Reference(Location)", "Another Location which this Location is physically part of.", 0, 1, this.partOf));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the location.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique code or number identifying the location to its users.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status property covers the general availability of the resource, not the current value which may be covered by the operationStatus, or by a schedule/slots if they are configured for the location.", 0, 1, this.status);
            }
            case -2103166364: {
                return new Property("operationalStatus", "Coding", "The Operational status covers operation values most relevant to beds (but can also apply to rooms/units/chair/etc such as an isolation unit/dialisys chair). This typically covers concepts such as contamination, housekeeping and other activities\u00a0like maintenance.", 0, 1, this.operationalStatus);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Name of the location as used by humans. Does not need to be unique.", 0, 1, this.name);
            }
            case 92902992: {
                return new Property("alias", "string", "A list of\u00a0alternate names that the location is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias);
            }
            case -1724546052: {
                return new Property("description", "string", "Description of the Location, which helps in finding or referencing the place.", 0, 1, this.description);
            }
            case 0x3339A3: {
                return new Property("mode", "code", "Indicates whether a resource instance represents a specific location or a class of locations.", 0, 1, this.mode);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Indicates the type of function performed at the location.", 0, 1, this.type);
            }
            case -1429363305: {
                return new Property("telecom", "ContactPoint", "The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case -1147692044: {
                return new Property(SP_ADDRESS, "Address", "Physical location.", 0, 1, this.address);
            }
            case -1474715471: {
                return new Property("physicalType", "CodeableConcept", "Physical form of the location, e.g. building, room, vehicle, road.", 0, 1, this.physicalType);
            }
            case 0x2C929929: {
                return new Property("position", "", "The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).", 0, 1, this.position);
            }
            case -2058947787: {
                return new Property("managingOrganization", "Reference(Organization)", "The organization responsible for the provisioning and upkeep of the location.", 0, 1, this.managingOrganization);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Location)", "Another Location which this Location is physically part of.", 0, 1, this.partOf);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the location.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -2103166364: {
                Base[] baseArray;
                if (this.operationalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.operationalStatus;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case 0x3339A3: {
                Base[] baseArray;
                if (this.mode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.mode;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.type;
                }
                return baseArray;
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1147692044: {
                Base[] baseArray;
                if (this.address == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.address;
                }
                return baseArray;
            }
            case -1474715471: {
                Base[] baseArray;
                if (this.physicalType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.physicalType;
                }
                return baseArray;
            }
            case 0x2C929929: {
                Base[] baseArray;
                if (this.position == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.position;
                }
                return baseArray;
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.partOf;
                }
                return baseArray;
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new LocationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -2103166364: {
                this.operationalStatus = this.castToCoding(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(this.castToString(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 0x3339A3: {
                value = new LocationModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
            case -1147692044: {
                this.address = this.castToAddress(value);
                return value;
            }
            case -1474715471: {
                this.physicalType = this.castToCodeableConcept(value);
                return value;
            }
            case 0x2C929929: {
                this.position = (LocationPositionComponent)((Object)value);
                return value;
            }
            case -2058947787: {
                this.managingOrganization = this.castToReference(value);
                return value;
            }
            case -995410646: {
                this.partOf = this.castToReference(value);
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new LocationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("operationalStatus")) {
            this.operationalStatus = this.castToCoding(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("mode")) {
            value = new LocationModeEnumFactory().fromType(this.castToCode(value));
            this.mode = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_ADDRESS)) {
            this.address = this.castToAddress(value);
        } else if (name.equals("physicalType")) {
            this.physicalType = this.castToCodeableConcept(value);
        } else if (name.equals("position")) {
            this.position = (LocationPositionComponent)((Object)value);
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -2103166364: {
                return this.getOperationalStatus();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 0x3339A3: {
                return this.getModeElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1147692044: {
                return this.getAddress();
            }
            case -1474715471: {
                return this.getPhysicalType();
            }
            case 0x2C929929: {
                return this.getPosition();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case -995410646: {
                return this.getPartOf();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -2103166364: {
                return new String[]{"Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 0x3339A3: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1147692044: {
                return new String[]{"Address"};
            }
            case -1474715471: {
                return new String[]{"CodeableConcept"};
            }
            case 0x2C929929: {
                return new String[0];
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Location.status");
        }
        if (name.equals("operationalStatus")) {
            this.operationalStatus = new Coding();
            return this.operationalStatus;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property Location.name");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a singleton property Location.alias");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Location.description");
        }
        if (name.equals("mode")) {
            throw new FHIRException("Cannot call addChild on a singleton property Location.mode");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals(SP_ADDRESS)) {
            this.address = new Address();
            return this.address;
        }
        if (name.equals("physicalType")) {
            this.physicalType = new CodeableConcept();
            return this.physicalType;
        }
        if (name.equals("position")) {
            this.position = new LocationPositionComponent();
            return this.position;
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Location";
    }

    @Override
    public Location copy() {
        Location dst = new Location();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.operationalStatus = this.operationalStatus == null ? null : this.operationalStatus.copy();
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType2 : this.alias) {
                dst.alias.add(stringType2.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        dst.mode = this.mode == null ? null : this.mode.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.address = this.address == null ? null : this.address.copy();
        dst.physicalType = this.physicalType == null ? null : this.physicalType.copy();
        dst.position = this.position == null ? null : this.position.copy();
        dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        Reference reference = dst.partOf = this.partOf == null ? null : this.partOf.copy();
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference2 : this.endpoint) {
                dst.endpoint.add(reference2.copy());
            }
        }
        return dst;
    }

    protected Location typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Location)) {
            return false;
        }
        Location o = (Location)other_;
        return Location.compareDeep(this.identifier, o.identifier, true) && Location.compareDeep(this.status, o.status, true) && Location.compareDeep(this.operationalStatus, o.operationalStatus, true) && Location.compareDeep(this.name, o.name, true) && Location.compareDeep(this.alias, o.alias, true) && Location.compareDeep(this.description, o.description, true) && Location.compareDeep(this.mode, o.mode, true) && Location.compareDeep(this.type, o.type, true) && Location.compareDeep(this.telecom, o.telecom, true) && Location.compareDeep(this.address, o.address, true) && Location.compareDeep(this.physicalType, o.physicalType, true) && Location.compareDeep(this.position, o.position, true) && Location.compareDeep(this.managingOrganization, o.managingOrganization, true) && Location.compareDeep(this.partOf, o.partOf, true) && Location.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Location)) {
            return false;
        }
        Location o = (Location)other_;
        return Location.compareValues(this.status, o.status, true) && Location.compareValues(this.name, o.name, true) && Location.compareValues(this.alias, o.alias, true) && Location.compareValues(this.description, o.description, true) && Location.compareValues(this.mode, o.mode, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.operationalStatus, this.name, this.alias, this.description, this.mode, this.type, this.telecom, this.address, this.physicalType, this.position, this.managingOrganization, this.partOf, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Location;
    }

    @Block
    public static class LocationPositionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="longitude", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Longitude with WGS84 datum", formalDefinition="Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below).")
        protected DecimalType longitude;
        @Child(name="latitude", type={DecimalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Latitude with WGS84 datum", formalDefinition="Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below).")
        protected DecimalType latitude;
        @Child(name="altitude", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Altitude with WGS84 datum", formalDefinition="Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below).")
        protected DecimalType altitude;
        private static final long serialVersionUID = -74276134L;

        public LocationPositionComponent() {
        }

        public LocationPositionComponent(DecimalType longitude, DecimalType latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public DecimalType getLongitudeElement() {
            if (this.longitude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LocationPositionComponent.longitude");
                }
                if (Configuration.doAutoCreate()) {
                    this.longitude = new DecimalType();
                }
            }
            return this.longitude;
        }

        public boolean hasLongitudeElement() {
            return this.longitude != null && !this.longitude.isEmpty();
        }

        public boolean hasLongitude() {
            return this.longitude != null && !this.longitude.isEmpty();
        }

        public LocationPositionComponent setLongitudeElement(DecimalType value) {
            this.longitude = value;
            return this;
        }

        public BigDecimal getLongitude() {
            return this.longitude == null ? null : (BigDecimal)this.longitude.getValue();
        }

        public LocationPositionComponent setLongitude(BigDecimal value) {
            if (this.longitude == null) {
                this.longitude = new DecimalType();
            }
            this.longitude.setValue(value);
            return this;
        }

        public LocationPositionComponent setLongitude(long value) {
            this.longitude = new DecimalType();
            this.longitude.setValue(value);
            return this;
        }

        public LocationPositionComponent setLongitude(double value) {
            this.longitude = new DecimalType();
            this.longitude.setValue(value);
            return this;
        }

        public DecimalType getLatitudeElement() {
            if (this.latitude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LocationPositionComponent.latitude");
                }
                if (Configuration.doAutoCreate()) {
                    this.latitude = new DecimalType();
                }
            }
            return this.latitude;
        }

        public boolean hasLatitudeElement() {
            return this.latitude != null && !this.latitude.isEmpty();
        }

        public boolean hasLatitude() {
            return this.latitude != null && !this.latitude.isEmpty();
        }

        public LocationPositionComponent setLatitudeElement(DecimalType value) {
            this.latitude = value;
            return this;
        }

        public BigDecimal getLatitude() {
            return this.latitude == null ? null : (BigDecimal)this.latitude.getValue();
        }

        public LocationPositionComponent setLatitude(BigDecimal value) {
            if (this.latitude == null) {
                this.latitude = new DecimalType();
            }
            this.latitude.setValue(value);
            return this;
        }

        public LocationPositionComponent setLatitude(long value) {
            this.latitude = new DecimalType();
            this.latitude.setValue(value);
            return this;
        }

        public LocationPositionComponent setLatitude(double value) {
            this.latitude = new DecimalType();
            this.latitude.setValue(value);
            return this;
        }

        public DecimalType getAltitudeElement() {
            if (this.altitude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LocationPositionComponent.altitude");
                }
                if (Configuration.doAutoCreate()) {
                    this.altitude = new DecimalType();
                }
            }
            return this.altitude;
        }

        public boolean hasAltitudeElement() {
            return this.altitude != null && !this.altitude.isEmpty();
        }

        public boolean hasAltitude() {
            return this.altitude != null && !this.altitude.isEmpty();
        }

        public LocationPositionComponent setAltitudeElement(DecimalType value) {
            this.altitude = value;
            return this;
        }

        public BigDecimal getAltitude() {
            return this.altitude == null ? null : (BigDecimal)this.altitude.getValue();
        }

        public LocationPositionComponent setAltitude(BigDecimal value) {
            if (value == null) {
                this.altitude = null;
            } else {
                if (this.altitude == null) {
                    this.altitude = new DecimalType();
                }
                this.altitude.setValue(value);
            }
            return this;
        }

        public LocationPositionComponent setAltitude(long value) {
            this.altitude = new DecimalType();
            this.altitude.setValue(value);
            return this;
        }

        public LocationPositionComponent setAltitude(double value) {
            this.altitude = new DecimalType();
            this.altitude.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("longitude", "decimal", "Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below).", 0, 1, this.longitude));
            children.add(new Property("latitude", "decimal", "Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below).", 0, 1, this.latitude));
            children.add(new Property("altitude", "decimal", "Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below).", 0, 1, this.altitude));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 137365935: {
                    return new Property("longitude", "decimal", "Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below).", 0, 1, this.longitude);
                }
                case -1439978388: {
                    return new Property("latitude", "decimal", "Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below).", 0, 1, this.latitude);
                }
                case 2036550306: {
                    return new Property("altitude", "decimal", "Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below).", 0, 1, this.altitude);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 137365935: {
                    Base[] baseArray;
                    if (this.longitude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.longitude;
                    }
                    return baseArray;
                }
                case -1439978388: {
                    Base[] baseArray;
                    if (this.latitude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.latitude;
                    }
                    return baseArray;
                }
                case 2036550306: {
                    Base[] baseArray;
                    if (this.altitude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.altitude;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 137365935: {
                    this.longitude = this.castToDecimal(value);
                    return value;
                }
                case -1439978388: {
                    this.latitude = this.castToDecimal(value);
                    return value;
                }
                case 2036550306: {
                    this.altitude = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("longitude")) {
                this.longitude = this.castToDecimal(value);
            } else if (name.equals("latitude")) {
                this.latitude = this.castToDecimal(value);
            } else if (name.equals("altitude")) {
                this.altitude = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 137365935: {
                    return this.getLongitudeElement();
                }
                case -1439978388: {
                    return this.getLatitudeElement();
                }
                case 2036550306: {
                    return this.getAltitudeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 137365935: {
                    return new String[]{"decimal"};
                }
                case -1439978388: {
                    return new String[]{"decimal"};
                }
                case 2036550306: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("longitude")) {
                throw new FHIRException("Cannot call addChild on a singleton property Location.longitude");
            }
            if (name.equals("latitude")) {
                throw new FHIRException("Cannot call addChild on a singleton property Location.latitude");
            }
            if (name.equals("altitude")) {
                throw new FHIRException("Cannot call addChild on a singleton property Location.altitude");
            }
            return super.addChild(name);
        }

        @Override
        public LocationPositionComponent copy() {
            LocationPositionComponent dst = new LocationPositionComponent();
            this.copyValues(dst);
            dst.longitude = this.longitude == null ? null : this.longitude.copy();
            dst.latitude = this.latitude == null ? null : this.latitude.copy();
            dst.altitude = this.altitude == null ? null : this.altitude.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof LocationPositionComponent)) {
                return false;
            }
            LocationPositionComponent o = (LocationPositionComponent)other_;
            return LocationPositionComponent.compareDeep(this.longitude, o.longitude, true) && LocationPositionComponent.compareDeep(this.latitude, o.latitude, true) && LocationPositionComponent.compareDeep(this.altitude, o.altitude, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof LocationPositionComponent)) {
                return false;
            }
            LocationPositionComponent o = (LocationPositionComponent)other_;
            return LocationPositionComponent.compareValues(this.longitude, o.longitude, true) && LocationPositionComponent.compareValues(this.latitude, o.latitude, true) && LocationPositionComponent.compareValues(this.altitude, o.altitude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.longitude, this.latitude, this.altitude});
        }

        @Override
        public String fhirType() {
            return "Location.position";
        }
    }

    public static class LocationModeEnumFactory
    implements EnumFactory<LocationMode> {
        @Override
        public LocationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return LocationMode.INSTANCE;
            }
            if ("kind".equals(codeString)) {
                return LocationMode.KIND;
            }
            throw new IllegalArgumentException("Unknown LocationMode code '" + codeString + "'");
        }

        public Enumeration<LocationMode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<LocationMode>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<LocationMode>(this, LocationMode.INSTANCE);
            }
            if ("kind".equals(codeString)) {
                return new Enumeration<LocationMode>(this, LocationMode.KIND);
            }
            throw new FHIRException("Unknown LocationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(LocationMode code) {
            if (code == LocationMode.NULL) {
                return null;
            }
            if (code == LocationMode.INSTANCE) {
                return "instance";
            }
            if (code == LocationMode.KIND) {
                return "kind";
            }
            return "?";
        }

        @Override
        public String toSystem(LocationMode code) {
            return code.getSystem();
        }
    }

    public static enum LocationMode {
        INSTANCE,
        KIND,
        NULL;


        public static LocationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("kind".equals(codeString)) {
                return KIND;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown LocationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case KIND: {
                    return "kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/location-mode";
                }
                case KIND: {
                    return "http://hl7.org/fhir/location-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The Location resource represents a specific instance of a location (e.g. Operating Theatre 1A).";
                }
                case KIND: {
                    return "The Location represents a class of locations (e.g. Any Operating Theatre) although this class of locations could be constrained within a specific boundary (such as organization, or parent location, address etc.).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case KIND: {
                    return "Kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class LocationStatusEnumFactory
    implements EnumFactory<LocationStatus> {
        @Override
        public LocationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return LocationStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return LocationStatus.SUSPENDED;
            }
            if ("inactive".equals(codeString)) {
                return LocationStatus.INACTIVE;
            }
            throw new IllegalArgumentException("Unknown LocationStatus code '" + codeString + "'");
        }

        public Enumeration<LocationStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<LocationStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<LocationStatus>(this, LocationStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<LocationStatus>(this, LocationStatus.SUSPENDED);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<LocationStatus>(this, LocationStatus.INACTIVE);
            }
            throw new FHIRException("Unknown LocationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(LocationStatus code) {
            if (code == LocationStatus.NULL) {
                return null;
            }
            if (code == LocationStatus.ACTIVE) {
                return "active";
            }
            if (code == LocationStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == LocationStatus.INACTIVE) {
                return "inactive";
            }
            return "?";
        }

        @Override
        public String toSystem(LocationStatus code) {
            return code.getSystem();
        }
    }

    public static enum LocationStatus {
        ACTIVE,
        SUSPENDED,
        INACTIVE,
        NULL;


        public static LocationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown LocationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/location-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/location-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/location-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The location is operational.";
                }
                case SUSPENDED: {
                    return "The location is temporarily closed.";
                }
                case INACTIVE: {
                    return "The location is no longer used.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

