/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServiceModifiers {
    SR,
    AH,
    NULL;


    public static ServiceModifiers fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("sr".equals(codeString)) {
            return SR;
        }
        if ("ah".equals(codeString)) {
            return AH;
        }
        throw new FHIRException("Unknown ServiceModifiers code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SR: {
                return "sr";
            }
            case AH: {
                return "ah";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-servicemodifier";
    }

    public String getDefinition() {
        switch (this) {
            case SR: {
                return "Services provided on the side of the raod or such other non-conventional setting.";
            }
            case AH: {
                return "Services provided outside or normal business hours.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SR: {
                return "Side of the Road";
            }
            case AH: {
                return "After hours";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

