/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ResourceTypeLink;

public class ResourceTypeLinkEnumFactory
implements EnumFactory<ResourceTypeLink> {
    @Override
    public ResourceTypeLink fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("organization".equals(codeString)) {
            return ResourceTypeLink.ORGANIZATION;
        }
        if ("patient".equals(codeString)) {
            return ResourceTypeLink.PATIENT;
        }
        if ("practitioner".equals(codeString)) {
            return ResourceTypeLink.PRACTITIONER;
        }
        if ("relatedperson".equals(codeString)) {
            return ResourceTypeLink.RELATEDPERSON;
        }
        throw new IllegalArgumentException("Unknown ResourceTypeLink code '" + codeString + "'");
    }

    @Override
    public String toCode(ResourceTypeLink code) {
        if (code == ResourceTypeLink.ORGANIZATION) {
            return "organization";
        }
        if (code == ResourceTypeLink.PATIENT) {
            return "patient";
        }
        if (code == ResourceTypeLink.PRACTITIONER) {
            return "practitioner";
        }
        if (code == ResourceTypeLink.RELATEDPERSON) {
            return "relatedperson";
        }
        return "?";
    }

    @Override
    public String toSystem(ResourceTypeLink code) {
        return code.getSystem();
    }
}

