/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ItemType;

public class ItemTypeEnumFactory
implements EnumFactory<ItemType> {
    @Override
    public ItemType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("group".equals(codeString)) {
            return ItemType.GROUP;
        }
        if ("display".equals(codeString)) {
            return ItemType.DISPLAY;
        }
        if ("question".equals(codeString)) {
            return ItemType.QUESTION;
        }
        if ("boolean".equals(codeString)) {
            return ItemType.BOOLEAN;
        }
        if ("decimal".equals(codeString)) {
            return ItemType.DECIMAL;
        }
        if ("integer".equals(codeString)) {
            return ItemType.INTEGER;
        }
        if ("date".equals(codeString)) {
            return ItemType.DATE;
        }
        if ("dateTime".equals(codeString)) {
            return ItemType.DATETIME;
        }
        if ("time".equals(codeString)) {
            return ItemType.TIME;
        }
        if ("string".equals(codeString)) {
            return ItemType.STRING;
        }
        if ("text".equals(codeString)) {
            return ItemType.TEXT;
        }
        if ("url".equals(codeString)) {
            return ItemType.URL;
        }
        if ("choice".equals(codeString)) {
            return ItemType.CHOICE;
        }
        if ("open-choice".equals(codeString)) {
            return ItemType.OPENCHOICE;
        }
        if ("attachment".equals(codeString)) {
            return ItemType.ATTACHMENT;
        }
        if ("reference".equals(codeString)) {
            return ItemType.REFERENCE;
        }
        if ("quantity".equals(codeString)) {
            return ItemType.QUANTITY;
        }
        throw new IllegalArgumentException("Unknown ItemType code '" + codeString + "'");
    }

    @Override
    public String toCode(ItemType code) {
        if (code == ItemType.GROUP) {
            return "group";
        }
        if (code == ItemType.DISPLAY) {
            return "display";
        }
        if (code == ItemType.QUESTION) {
            return "question";
        }
        if (code == ItemType.BOOLEAN) {
            return "boolean";
        }
        if (code == ItemType.DECIMAL) {
            return "decimal";
        }
        if (code == ItemType.INTEGER) {
            return "integer";
        }
        if (code == ItemType.DATE) {
            return "date";
        }
        if (code == ItemType.DATETIME) {
            return "dateTime";
        }
        if (code == ItemType.TIME) {
            return "time";
        }
        if (code == ItemType.STRING) {
            return "string";
        }
        if (code == ItemType.TEXT) {
            return "text";
        }
        if (code == ItemType.URL) {
            return "url";
        }
        if (code == ItemType.CHOICE) {
            return "choice";
        }
        if (code == ItemType.OPENCHOICE) {
            return "open-choice";
        }
        if (code == ItemType.ATTACHMENT) {
            return "attachment";
        }
        if (code == ItemType.REFERENCE) {
            return "reference";
        }
        if (code == ItemType.QUANTITY) {
            return "quantity";
        }
        return "?";
    }

    @Override
    public String toSystem(ItemType code) {
        return code.getSystem();
    }
}

