/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CommunicationRequestStatus;

public class CommunicationRequestStatusEnumFactory
implements EnumFactory<CommunicationRequestStatus> {
    @Override
    public CommunicationRequestStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return CommunicationRequestStatus.PROPOSED;
        }
        if ("planned".equals(codeString)) {
            return CommunicationRequestStatus.PLANNED;
        }
        if ("requested".equals(codeString)) {
            return CommunicationRequestStatus.REQUESTED;
        }
        if ("received".equals(codeString)) {
            return CommunicationRequestStatus.RECEIVED;
        }
        if ("accepted".equals(codeString)) {
            return CommunicationRequestStatus.ACCEPTED;
        }
        if ("in-progress".equals(codeString)) {
            return CommunicationRequestStatus.INPROGRESS;
        }
        if ("completed".equals(codeString)) {
            return CommunicationRequestStatus.COMPLETED;
        }
        if ("suspended".equals(codeString)) {
            return CommunicationRequestStatus.SUSPENDED;
        }
        if ("rejected".equals(codeString)) {
            return CommunicationRequestStatus.REJECTED;
        }
        if ("failed".equals(codeString)) {
            return CommunicationRequestStatus.FAILED;
        }
        throw new IllegalArgumentException("Unknown CommunicationRequestStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(CommunicationRequestStatus code) {
        if (code == CommunicationRequestStatus.PROPOSED) {
            return "proposed";
        }
        if (code == CommunicationRequestStatus.PLANNED) {
            return "planned";
        }
        if (code == CommunicationRequestStatus.REQUESTED) {
            return "requested";
        }
        if (code == CommunicationRequestStatus.RECEIVED) {
            return "received";
        }
        if (code == CommunicationRequestStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == CommunicationRequestStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == CommunicationRequestStatus.COMPLETED) {
            return "completed";
        }
        if (code == CommunicationRequestStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == CommunicationRequestStatus.REJECTED) {
            return "rejected";
        }
        if (code == CommunicationRequestStatus.FAILED) {
            return "failed";
        }
        return "?";
    }

    @Override
    public String toSystem(CommunicationRequestStatus code) {
        return code.getSystem();
    }
}

