/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AuditEventOutcome {
    _0,
    _4,
    _8,
    _12,
    NULL;


    public static AuditEventOutcome fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("0".equals(codeString)) {
            return _0;
        }
        if ("4".equals(codeString)) {
            return _4;
        }
        if ("8".equals(codeString)) {
            return _8;
        }
        if ("12".equals(codeString)) {
            return _12;
        }
        throw new FHIRException("Unknown AuditEventOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _0: {
                return "0";
            }
            case _4: {
                return "4";
            }
            case _8: {
                return "8";
            }
            case _12: {
                return "12";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/audit-event-outcome";
    }

    public String getDefinition() {
        switch (this) {
            case _0: {
                return "The operation completed successfully (whether with warnings or not).";
            }
            case _4: {
                return "The action was not successful due to some kind of catered for error (often equivalent to an HTTP 400 response).";
            }
            case _8: {
                return "The action was not successful due to some kind of unexpected error (often equivalent to an HTTP 500 response).";
            }
            case _12: {
                return "An error of such magnitude occurred that the system is no longer available for use (i.e. the system died).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _0: {
                return "Success";
            }
            case _4: {
                return "Minor failure";
            }
            case _8: {
                return "Serious failure";
            }
            case _12: {
                return "Major failure";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

