/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCausalityMethod {
    METHOD1,
    METHOD2,
    NULL;


    public static AdverseEventCausalityMethod fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("method1".equals(codeString)) {
            return METHOD1;
        }
        if ("method2".equals(codeString)) {
            return METHOD2;
        }
        throw new FHIRException("Unknown AdverseEventCausalityMethod code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case METHOD1: {
                return "method1";
            }
            case METHOD2: {
                return "method2";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-causality-method";
    }

    public String getDefinition() {
        switch (this) {
            case METHOD1: {
                return "";
            }
            case METHOD2: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case METHOD1: {
                return "placeholder";
            }
            case METHOD2: {
                return "placeholder";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

