/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.ResearchStudy;
import org.hl7.fhir.dstu3.model.ResearchSubject;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AdverseEvent", profile="http://hl7.org/fhir/Profile/AdverseEvent")
public class AdverseEvent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the event", formalDefinition="The identifier(s) of this adverse event that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itsefl is not appropriate.")
    protected Identifier identifier;
    @Child(name="category", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="AE | PAE \rAn adverse event is an event that caused harm to a patient,  an adverse reaction is a something that is a subject-specific event that is a result of an exposure to a medication, food, device or environmental substance, a potential adverse event is something that occurred and that could have caused harm to a patient but did not", formalDefinition="The type of event which is important to characterize what occurred and caused harm to the subject, or had the potential to cause harm to the subject.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-category")
    protected Enumeration<AdverseEventCategory> category;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="actual | potential", formalDefinition="This element defines the specific type of event that occurred or that was prevented from occurring.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-type")
    protected CodeableConcept type;
    @Child(name="subject", type={Patient.class, ResearchSubject.class, Medication.class, Device.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subject or group impacted by event", formalDefinition="This subject or group impacted by the event.  With a prospective adverse event, there will be no subject as the adverse event was prevented.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="date", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event occurred", formalDefinition="The date (and perhaps time) when the adverse event occurred.")
    protected DateTimeType date;
    @Child(name="reaction", type={Condition.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Adverse Reaction Events linked to exposure to substance", formalDefinition="Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).")
    protected List<Reference> reaction;
    protected List<Condition> reactionTarget;
    @Child(name="location", type={Location.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Location where adverse event occurred", formalDefinition="The information about where the adverse event occurred.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="seriousness", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Mild | Moderate | Severe", formalDefinition="Describes the seriousness or severity of the adverse event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-seriousness")
    protected CodeableConcept seriousness;
    @Child(name="outcome", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="resolved | recovering | ongoing | resolvedWithSequelae | fatal | unknown", formalDefinition="Describes the type of outcome from the adverse event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-outcome")
    protected CodeableConcept outcome;
    @Child(name="recorder", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who recorded the adverse event", formalDefinition="Information on who recorded the adverse event.  May be the patient or a practitioner.")
    protected Reference recorder;
    protected Resource recorderTarget;
    @Child(name="eventParticipant", type={Practitioner.class, Device.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who  was involved in the adverse event or the potential adverse event", formalDefinition="Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g. consultant), information that the Act itself seeks to reveal (e.g. informant of clinical history), or information about what Act was performed (e.g. informant witness).")
    protected Reference eventParticipant;
    protected Resource eventParticipantTarget;
    @Child(name="description", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of the adverse event", formalDefinition="Describes the adverse event in text.")
    protected StringType description;
    @Child(name="suspectEntity", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The suspected agent causing the adverse event", formalDefinition="Describes the entity that is suspected to have caused the adverse event.")
    protected List<AdverseEventSuspectEntityComponent> suspectEntity;
    @Child(name="subjectMedicalHistory", type={Condition.class, Observation.class, AllergyIntolerance.class, FamilyMemberHistory.class, Immunization.class, Procedure.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="AdverseEvent.subjectMedicalHistory", formalDefinition="AdverseEvent.subjectMedicalHistory.")
    protected List<Reference> subjectMedicalHistory;
    protected List<Resource> subjectMedicalHistoryTarget;
    @Child(name="referenceDocument", type={DocumentReference.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="AdverseEvent.referenceDocument", formalDefinition="AdverseEvent.referenceDocument.")
    protected List<Reference> referenceDocument;
    protected List<DocumentReference> referenceDocumentTarget;
    @Child(name="study", type={ResearchStudy.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="AdverseEvent.study", formalDefinition="AdverseEvent.study.")
    protected List<Reference> study;
    protected List<ResearchStudy> studyTarget;
    private static final long serialVersionUID = 156251238L;
    @SearchParamDefinition(name="date", path="AdverseEvent.date", description="When the event occurred", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="recorder", path="AdverseEvent.recorder", description="Who recorded the adverse event", type="reference", providesMembershipIn={@Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("AdverseEvent:recorder").toLocked();
    @SearchParamDefinition(name="study", path="AdverseEvent.study", description="AdverseEvent.study", type="reference", target={ResearchStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("AdverseEvent:study").toLocked();
    @SearchParamDefinition(name="reaction", path="AdverseEvent.reaction", description="Adverse Reaction Events linked to exposure to substance", type="reference", target={Condition.class})
    public static final String SP_REACTION = "reaction";
    public static final ReferenceClientParam REACTION = new ReferenceClientParam("reaction");
    public static final Include INCLUDE_REACTION = new Include("AdverseEvent:reaction").toLocked();
    @SearchParamDefinition(name="seriousness", path="AdverseEvent.seriousness", description="Mild | Moderate | Severe", type="token")
    public static final String SP_SERIOUSNESS = "seriousness";
    public static final TokenClientParam SERIOUSNESS = new TokenClientParam("seriousness");
    @SearchParamDefinition(name="subject", path="AdverseEvent.subject", description="Subject or group impacted by event", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Device.class, Medication.class, Patient.class, ResearchSubject.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("AdverseEvent:subject").toLocked();
    @SearchParamDefinition(name="substance", path="AdverseEvent.suspectEntity.instance", description="Refers to the specific entity that caused the adverse event", type="reference", target={Device.class, Medication.class, MedicationAdministration.class, MedicationStatement.class, Substance.class})
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_SUBSTANCE = new Include("AdverseEvent:substance").toLocked();
    @SearchParamDefinition(name="location", path="AdverseEvent.location", description="Location where adverse event occurred", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("AdverseEvent:location").toLocked();
    @SearchParamDefinition(name="category", path="AdverseEvent.category", description="AE | PAE \rAn adverse event is an event that caused harm to a patient,  an adverse reaction is a something that is a subject-specific event that is a result of an exposure to a medication, food, device or environmental substance, a potential adverse event is something that occurred and that could have caused harm to a patient but did not", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="type", path="AdverseEvent.type", description="actual | potential", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public AdverseEvent setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<AdverseEventCategory> getCategoryElement() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new Enumeration<AdverseEventCategory>(new AdverseEventCategoryEnumFactory());
            }
        }
        return this.category;
    }

    public boolean hasCategoryElement() {
        return this.category != null && !this.category.isEmpty();
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public AdverseEvent setCategoryElement(Enumeration<AdverseEventCategory> value) {
        this.category = value;
        return this;
    }

    public AdverseEventCategory getCategory() {
        return this.category == null ? null : (AdverseEventCategory)((Object)this.category.getValue());
    }

    public AdverseEvent setCategory(AdverseEventCategory value) {
        if (value == null) {
            this.category = null;
        } else {
            if (this.category == null) {
                this.category = new Enumeration<AdverseEventCategory>(new AdverseEventCategoryEnumFactory());
            }
            this.category.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public AdverseEvent setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public AdverseEvent setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public AdverseEvent setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public AdverseEvent setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public AdverseEvent setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<Reference> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<Reference>();
        }
        return this.reaction;
    }

    public AdverseEvent setReaction(List<Reference> theReaction) {
        this.reaction = theReaction;
        return this;
    }

    public boolean hasReaction() {
        if (this.reaction == null) {
            return false;
        }
        for (Reference item : this.reaction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReaction() {
        Reference t = new Reference();
        if (this.reaction == null) {
            this.reaction = new ArrayList<Reference>();
        }
        this.reaction.add(t);
        return t;
    }

    public AdverseEvent addReaction(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reaction == null) {
            this.reaction = new ArrayList<Reference>();
        }
        this.reaction.add(t);
        return this;
    }

    public Reference getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            this.addReaction();
        }
        return this.getReaction().get(0);
    }

    @Deprecated
    public List<Condition> getReactionTarget() {
        if (this.reactionTarget == null) {
            this.reactionTarget = new ArrayList<Condition>();
        }
        return this.reactionTarget;
    }

    @Deprecated
    public Condition addReactionTarget() {
        Condition r = new Condition();
        if (this.reactionTarget == null) {
            this.reactionTarget = new ArrayList<Condition>();
        }
        this.reactionTarget.add(r);
        return r;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public AdverseEvent setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public AdverseEvent setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public CodeableConcept getSeriousness() {
        if (this.seriousness == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.seriousness");
            }
            if (Configuration.doAutoCreate()) {
                this.seriousness = new CodeableConcept();
            }
        }
        return this.seriousness;
    }

    public boolean hasSeriousness() {
        return this.seriousness != null && !this.seriousness.isEmpty();
    }

    public AdverseEvent setSeriousness(CodeableConcept value) {
        this.seriousness = value;
        return this;
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public AdverseEvent setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public AdverseEvent setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public Resource getRecorderTarget() {
        return this.recorderTarget;
    }

    public AdverseEvent setRecorderTarget(Resource value) {
        this.recorderTarget = value;
        return this;
    }

    public Reference getEventParticipant() {
        if (this.eventParticipant == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.eventParticipant");
            }
            if (Configuration.doAutoCreate()) {
                this.eventParticipant = new Reference();
            }
        }
        return this.eventParticipant;
    }

    public boolean hasEventParticipant() {
        return this.eventParticipant != null && !this.eventParticipant.isEmpty();
    }

    public AdverseEvent setEventParticipant(Reference value) {
        this.eventParticipant = value;
        return this;
    }

    public Resource getEventParticipantTarget() {
        return this.eventParticipantTarget;
    }

    public AdverseEvent setEventParticipantTarget(Resource value) {
        this.eventParticipantTarget = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public AdverseEvent setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public AdverseEvent setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<AdverseEventSuspectEntityComponent> getSuspectEntity() {
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        return this.suspectEntity;
    }

    public AdverseEvent setSuspectEntity(List<AdverseEventSuspectEntityComponent> theSuspectEntity) {
        this.suspectEntity = theSuspectEntity;
        return this;
    }

    public boolean hasSuspectEntity() {
        if (this.suspectEntity == null) {
            return false;
        }
        for (AdverseEventSuspectEntityComponent item : this.suspectEntity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventSuspectEntityComponent addSuspectEntity() {
        AdverseEventSuspectEntityComponent t = new AdverseEventSuspectEntityComponent();
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        this.suspectEntity.add(t);
        return t;
    }

    public AdverseEvent addSuspectEntity(AdverseEventSuspectEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        this.suspectEntity.add(t);
        return this;
    }

    public AdverseEventSuspectEntityComponent getSuspectEntityFirstRep() {
        if (this.getSuspectEntity().isEmpty()) {
            this.addSuspectEntity();
        }
        return this.getSuspectEntity().get(0);
    }

    public List<Reference> getSubjectMedicalHistory() {
        if (this.subjectMedicalHistory == null) {
            this.subjectMedicalHistory = new ArrayList<Reference>();
        }
        return this.subjectMedicalHistory;
    }

    public AdverseEvent setSubjectMedicalHistory(List<Reference> theSubjectMedicalHistory) {
        this.subjectMedicalHistory = theSubjectMedicalHistory;
        return this;
    }

    public boolean hasSubjectMedicalHistory() {
        if (this.subjectMedicalHistory == null) {
            return false;
        }
        for (Reference item : this.subjectMedicalHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubjectMedicalHistory() {
        Reference t = new Reference();
        if (this.subjectMedicalHistory == null) {
            this.subjectMedicalHistory = new ArrayList<Reference>();
        }
        this.subjectMedicalHistory.add(t);
        return t;
    }

    public AdverseEvent addSubjectMedicalHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subjectMedicalHistory == null) {
            this.subjectMedicalHistory = new ArrayList<Reference>();
        }
        this.subjectMedicalHistory.add(t);
        return this;
    }

    public Reference getSubjectMedicalHistoryFirstRep() {
        if (this.getSubjectMedicalHistory().isEmpty()) {
            this.addSubjectMedicalHistory();
        }
        return this.getSubjectMedicalHistory().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectMedicalHistoryTarget() {
        if (this.subjectMedicalHistoryTarget == null) {
            this.subjectMedicalHistoryTarget = new ArrayList<Resource>();
        }
        return this.subjectMedicalHistoryTarget;
    }

    public List<Reference> getReferenceDocument() {
        if (this.referenceDocument == null) {
            this.referenceDocument = new ArrayList<Reference>();
        }
        return this.referenceDocument;
    }

    public AdverseEvent setReferenceDocument(List<Reference> theReferenceDocument) {
        this.referenceDocument = theReferenceDocument;
        return this;
    }

    public boolean hasReferenceDocument() {
        if (this.referenceDocument == null) {
            return false;
        }
        for (Reference item : this.referenceDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReferenceDocument() {
        Reference t = new Reference();
        if (this.referenceDocument == null) {
            this.referenceDocument = new ArrayList<Reference>();
        }
        this.referenceDocument.add(t);
        return t;
    }

    public AdverseEvent addReferenceDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.referenceDocument == null) {
            this.referenceDocument = new ArrayList<Reference>();
        }
        this.referenceDocument.add(t);
        return this;
    }

    public Reference getReferenceDocumentFirstRep() {
        if (this.getReferenceDocument().isEmpty()) {
            this.addReferenceDocument();
        }
        return this.getReferenceDocument().get(0);
    }

    @Deprecated
    public List<DocumentReference> getReferenceDocumentTarget() {
        if (this.referenceDocumentTarget == null) {
            this.referenceDocumentTarget = new ArrayList<DocumentReference>();
        }
        return this.referenceDocumentTarget;
    }

    @Deprecated
    public DocumentReference addReferenceDocumentTarget() {
        DocumentReference r = new DocumentReference();
        if (this.referenceDocumentTarget == null) {
            this.referenceDocumentTarget = new ArrayList<DocumentReference>();
        }
        this.referenceDocumentTarget.add(r);
        return r;
    }

    public List<Reference> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        return this.study;
    }

    public AdverseEvent setStudy(List<Reference> theStudy) {
        this.study = theStudy;
        return this;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (Reference item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addStudy() {
        Reference t = new Reference();
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return t;
    }

    public AdverseEvent addStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return this;
    }

    public Reference getStudyFirstRep() {
        if (this.getStudy().isEmpty()) {
            this.addStudy();
        }
        return this.getStudy().get(0);
    }

    @Deprecated
    public List<ResearchStudy> getStudyTarget() {
        if (this.studyTarget == null) {
            this.studyTarget = new ArrayList<ResearchStudy>();
        }
        return this.studyTarget;
    }

    @Deprecated
    public ResearchStudy addStudyTarget() {
        ResearchStudy r = new ResearchStudy();
        if (this.studyTarget == null) {
            this.studyTarget = new ArrayList<ResearchStudy>();
        }
        this.studyTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "The identifier(s) of this adverse event that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itsefl is not appropriate.", 0, 1, this.identifier));
        children.add(new Property(SP_CATEGORY, "code", "The type of event which is important to characterize what occurred and caused harm to the subject, or had the potential to cause harm to the subject.", 0, 1, this.category));
        children.add(new Property(SP_TYPE, "CodeableConcept", "This element defines the specific type of event that occurred or that was prevented from occurring.", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|ResearchSubject|Medication|Device)", "This subject or group impacted by the event.  With a prospective adverse event, there will be no subject as the adverse event was prevented.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.date));
        children.add(new Property(SP_REACTION, "Reference(Condition)", "Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).", 0, Integer.MAX_VALUE, this.reaction));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The information about where the adverse event occurred.", 0, 1, this.location));
        children.add(new Property(SP_SERIOUSNESS, "CodeableConcept", "Describes the seriousness or severity of the adverse event.", 0, 1, this.seriousness));
        children.add(new Property("outcome", "CodeableConcept", "Describes the type of outcome from the adverse event.", 0, 1, this.outcome));
        children.add(new Property(SP_RECORDER, "Reference(Patient|Practitioner|RelatedPerson)", "Information on who recorded the adverse event.  May be the patient or a practitioner.", 0, 1, this.recorder));
        children.add(new Property("eventParticipant", "Reference(Practitioner|Device)", "Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g. consultant), information that the Act itself seeks to reveal (e.g. informant of clinical history), or information about what Act was performed (e.g. informant witness).", 0, 1, this.eventParticipant));
        children.add(new Property("description", "string", "Describes the adverse event in text.", 0, 1, this.description));
        children.add(new Property("suspectEntity", "", "Describes the entity that is suspected to have caused the adverse event.", 0, Integer.MAX_VALUE, this.suspectEntity));
        children.add(new Property("subjectMedicalHistory", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure)", "AdverseEvent.subjectMedicalHistory.", 0, Integer.MAX_VALUE, this.subjectMedicalHistory));
        children.add(new Property("referenceDocument", "Reference(DocumentReference)", "AdverseEvent.referenceDocument.", 0, Integer.MAX_VALUE, this.referenceDocument));
        children.add(new Property(SP_STUDY, "Reference(ResearchStudy)", "AdverseEvent.study.", 0, Integer.MAX_VALUE, this.study));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "The identifier(s) of this adverse event that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itsefl is not appropriate.", 0, 1, this.identifier);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "code", "The type of event which is important to characterize what occurred and caused harm to the subject, or had the potential to cause harm to the subject.", 0, 1, this.category);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "This element defines the specific type of event that occurred or that was prevented from occurring.", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|ResearchSubject|Medication|Device)", "This subject or group impacted by the event.  With a prospective adverse event, there will be no subject as the adverse event was prevented.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.date);
            }
            case -867509719: {
                return new Property(SP_REACTION, "Reference(Condition)", "Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).", 0, Integer.MAX_VALUE, this.reaction);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The information about where the adverse event occurred.", 0, 1, this.location);
            }
            case -1551003909: {
                return new Property(SP_SERIOUSNESS, "CodeableConcept", "Describes the seriousness or severity of the adverse event.", 0, 1, this.seriousness);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableConcept", "Describes the type of outcome from the adverse event.", 0, 1, this.outcome);
            }
            case -799233858: {
                return new Property(SP_RECORDER, "Reference(Patient|Practitioner|RelatedPerson)", "Information on who recorded the adverse event.  May be the patient or a practitioner.", 0, 1, this.recorder);
            }
            case 270753849: {
                return new Property("eventParticipant", "Reference(Practitioner|Device)", "Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g. consultant), information that the Act itself seeks to reveal (e.g. informant of clinical history), or information about what Act was performed (e.g. informant witness).", 0, 1, this.eventParticipant);
            }
            case -1724546052: {
                return new Property("description", "string", "Describes the adverse event in text.", 0, 1, this.description);
            }
            case -1957422662: {
                return new Property("suspectEntity", "", "Describes the entity that is suspected to have caused the adverse event.", 0, Integer.MAX_VALUE, this.suspectEntity);
            }
            case -1685245681: {
                return new Property("subjectMedicalHistory", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure)", "AdverseEvent.subjectMedicalHistory.", 0, Integer.MAX_VALUE, this.subjectMedicalHistory);
            }
            case 1013971334: {
                return new Property("referenceDocument", "Reference(DocumentReference)", "AdverseEvent.referenceDocument.", 0, Integer.MAX_VALUE, this.referenceDocument);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(ResearchStudy)", "AdverseEvent.study.", 0, Integer.MAX_VALUE, this.study);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.category;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case -867509719: {
                return this.reaction == null ? new Base[]{} : this.reaction.toArray(new Base[this.reaction.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.location;
                }
                return baseArray;
            }
            case -1551003909: {
                Base[] baseArray;
                if (this.seriousness == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.seriousness;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.outcome;
                }
                return baseArray;
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.recorder;
                }
                return baseArray;
            }
            case 270753849: {
                Base[] baseArray;
                if (this.eventParticipant == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.eventParticipant;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -1957422662: {
                return this.suspectEntity == null ? new Base[]{} : this.suspectEntity.toArray(new Base[this.suspectEntity.size()]);
            }
            case -1685245681: {
                return this.subjectMedicalHistory == null ? new Base[]{} : this.subjectMedicalHistory.toArray(new Base[this.subjectMedicalHistory.size()]);
            }
            case 1013971334: {
                return this.referenceDocument == null ? new Base[]{} : this.referenceDocument.toArray(new Base[this.referenceDocument.size()]);
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 50511102: {
                value = new AdverseEventCategoryEnumFactory().fromType(this.castToCode(value));
                this.category = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -867509719: {
                this.getReaction().add(this.castToReference(value));
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case -1551003909: {
                this.seriousness = this.castToCodeableConcept(value);
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToCodeableConcept(value);
                return value;
            }
            case -799233858: {
                this.recorder = this.castToReference(value);
                return value;
            }
            case 270753849: {
                this.eventParticipant = this.castToReference(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -1957422662: {
                this.getSuspectEntity().add((AdverseEventSuspectEntityComponent)((Object)value));
                return value;
            }
            case -1685245681: {
                this.getSubjectMedicalHistory().add(this.castToReference(value));
                return value;
            }
            case 1013971334: {
                this.getReferenceDocument().add(this.castToReference(value));
                return value;
            }
            case 109776329: {
                this.getStudy().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_CATEGORY)) {
            value = new AdverseEventCategoryEnumFactory().fromType(this.castToCode(value));
            this.category = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_REACTION)) {
            this.getReaction().add(this.castToReference(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_SERIOUSNESS)) {
            this.seriousness = this.castToCodeableConcept(value);
        } else if (name.equals("outcome")) {
            this.outcome = this.castToCodeableConcept(value);
        } else if (name.equals(SP_RECORDER)) {
            this.recorder = this.castToReference(value);
        } else if (name.equals("eventParticipant")) {
            this.eventParticipant = this.castToReference(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("suspectEntity")) {
            this.getSuspectEntity().add((AdverseEventSuspectEntityComponent)((Object)value));
        } else if (name.equals("subjectMedicalHistory")) {
            this.getSubjectMedicalHistory().add(this.castToReference(value));
        } else if (name.equals("referenceDocument")) {
            this.getReferenceDocument().add(this.castToReference(value));
        } else if (name.equals(SP_STUDY)) {
            this.getStudy().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 50511102: {
                return this.getCategoryElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -867509719: {
                return this.addReaction();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1551003909: {
                return this.getSeriousness();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case 270753849: {
                return this.getEventParticipant();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1957422662: {
                return this.addSuspectEntity();
            }
            case -1685245681: {
                return this.addSubjectMedicalHistory();
            }
            case 1013971334: {
                return this.addReferenceDocument();
            }
            case 109776329: {
                return this.addStudy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 50511102: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -867509719: {
                return new String[]{"Reference"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1551003909: {
                return new String[]{"CodeableConcept"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case 270753849: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1957422662: {
                return new String[0];
            }
            case -1685245681: {
                return new String[]{"Reference"};
            }
            case 1013971334: {
                return new String[]{"Reference"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.category");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.date");
        }
        if (name.equals(SP_REACTION)) {
            return this.addReaction();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_SERIOUSNESS)) {
            this.seriousness = new CodeableConcept();
            return this.seriousness;
        }
        if (name.equals("outcome")) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals(SP_RECORDER)) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals("eventParticipant")) {
            this.eventParticipant = new Reference();
            return this.eventParticipant;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.description");
        }
        if (name.equals("suspectEntity")) {
            return this.addSuspectEntity();
        }
        if (name.equals("subjectMedicalHistory")) {
            return this.addSubjectMedicalHistory();
        }
        if (name.equals("referenceDocument")) {
            return this.addReferenceDocument();
        }
        if (name.equals(SP_STUDY)) {
            return this.addStudy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AdverseEvent";
    }

    @Override
    public AdverseEvent copy() {
        AdverseEvent dst = new AdverseEvent();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.reaction != null) {
            dst.reaction = new ArrayList<Reference>();
            for (Reference reference : this.reaction) {
                dst.reaction.add(reference.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        dst.seriousness = this.seriousness == null ? null : this.seriousness.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.recorder = this.recorder == null ? null : this.recorder.copy();
        dst.eventParticipant = this.eventParticipant == null ? null : this.eventParticipant.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.suspectEntity != null) {
            dst.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
            for (AdverseEventSuspectEntityComponent adverseEventSuspectEntityComponent : this.suspectEntity) {
                dst.suspectEntity.add(adverseEventSuspectEntityComponent.copy());
            }
        }
        if (this.subjectMedicalHistory != null) {
            dst.subjectMedicalHistory = new ArrayList<Reference>();
            for (Reference reference : this.subjectMedicalHistory) {
                dst.subjectMedicalHistory.add(reference.copy());
            }
        }
        if (this.referenceDocument != null) {
            dst.referenceDocument = new ArrayList<Reference>();
            for (Reference reference : this.referenceDocument) {
                dst.referenceDocument.add(reference.copy());
            }
        }
        if (this.study != null) {
            dst.study = new ArrayList<Reference>();
            for (Reference reference : this.study) {
                dst.study.add(reference.copy());
            }
        }
        return dst;
    }

    protected AdverseEvent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AdverseEvent)) {
            return false;
        }
        AdverseEvent o = (AdverseEvent)other_;
        return AdverseEvent.compareDeep(this.identifier, o.identifier, true) && AdverseEvent.compareDeep(this.category, o.category, true) && AdverseEvent.compareDeep(this.type, o.type, true) && AdverseEvent.compareDeep(this.subject, o.subject, true) && AdverseEvent.compareDeep(this.date, o.date, true) && AdverseEvent.compareDeep(this.reaction, o.reaction, true) && AdverseEvent.compareDeep(this.location, o.location, true) && AdverseEvent.compareDeep(this.seriousness, o.seriousness, true) && AdverseEvent.compareDeep(this.outcome, o.outcome, true) && AdverseEvent.compareDeep(this.recorder, o.recorder, true) && AdverseEvent.compareDeep(this.eventParticipant, o.eventParticipant, true) && AdverseEvent.compareDeep(this.description, o.description, true) && AdverseEvent.compareDeep(this.suspectEntity, o.suspectEntity, true) && AdverseEvent.compareDeep(this.subjectMedicalHistory, o.subjectMedicalHistory, true) && AdverseEvent.compareDeep(this.referenceDocument, o.referenceDocument, true) && AdverseEvent.compareDeep(this.study, o.study, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AdverseEvent)) {
            return false;
        }
        AdverseEvent o = (AdverseEvent)other_;
        return AdverseEvent.compareValues(this.category, o.category, true) && AdverseEvent.compareValues(this.date, o.date, true) && AdverseEvent.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.category, this.type, this.subject, this.date, this.reaction, this.location, this.seriousness, this.outcome, this.recorder, this.eventParticipant, this.description, this.suspectEntity, this.subjectMedicalHistory, this.referenceDocument, this.study});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AdverseEvent;
    }

    @Block
    public static class AdverseEventSuspectEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="instance", type={Substance.class, Medication.class, MedicationAdministration.class, MedicationStatement.class, Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Refers to the specific entity that caused the adverse event", formalDefinition="Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.")
        protected Reference instance;
        protected Resource instanceTarget;
        @Child(name="causality", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="causality1 | causality2", formalDefinition="causality1 | causality2.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality")
        protected Enumeration<AdverseEventCausality> causality;
        @Child(name="causalityAssessment", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="assess1 | assess2", formalDefinition="assess1 | assess2.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-assess")
        protected CodeableConcept causalityAssessment;
        @Child(name="causalityProductRelatedness", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="AdverseEvent.suspectEntity.causalityProductRelatedness", formalDefinition="AdverseEvent.suspectEntity.causalityProductRelatedness.")
        protected StringType causalityProductRelatedness;
        @Child(name="causalityMethod", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="method1 | method2", formalDefinition="method1 | method2.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-method")
        protected CodeableConcept causalityMethod;
        @Child(name="causalityAuthor", type={Practitioner.class, PractitionerRole.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="AdverseEvent.suspectEntity.causalityAuthor", formalDefinition="AdverseEvent.suspectEntity.causalityAuthor.")
        protected Reference causalityAuthor;
        protected Resource causalityAuthorTarget;
        @Child(name="causalityResult", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="result1 | result2", formalDefinition="result1 | result2.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-result")
        protected CodeableConcept causalityResult;
        private static final long serialVersionUID = -815429592L;

        public AdverseEventSuspectEntityComponent() {
        }

        public AdverseEventSuspectEntityComponent(Reference instance) {
            this.instance = instance;
        }

        public Reference getInstance() {
            if (this.instance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.instance");
                }
                if (Configuration.doAutoCreate()) {
                    this.instance = new Reference();
                }
            }
            return this.instance;
        }

        public boolean hasInstance() {
            return this.instance != null && !this.instance.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setInstance(Reference value) {
            this.instance = value;
            return this;
        }

        public Resource getInstanceTarget() {
            return this.instanceTarget;
        }

        public AdverseEventSuspectEntityComponent setInstanceTarget(Resource value) {
            this.instanceTarget = value;
            return this;
        }

        public Enumeration<AdverseEventCausality> getCausalityElement() {
            if (this.causality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causality");
                }
                if (Configuration.doAutoCreate()) {
                    this.causality = new Enumeration<AdverseEventCausality>(new AdverseEventCausalityEnumFactory());
                }
            }
            return this.causality;
        }

        public boolean hasCausalityElement() {
            return this.causality != null && !this.causality.isEmpty();
        }

        public boolean hasCausality() {
            return this.causality != null && !this.causality.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausalityElement(Enumeration<AdverseEventCausality> value) {
            this.causality = value;
            return this;
        }

        public AdverseEventCausality getCausality() {
            return this.causality == null ? null : (AdverseEventCausality)((Object)this.causality.getValue());
        }

        public AdverseEventSuspectEntityComponent setCausality(AdverseEventCausality value) {
            if (value == null) {
                this.causality = null;
            } else {
                if (this.causality == null) {
                    this.causality = new Enumeration<AdverseEventCausality>(new AdverseEventCausalityEnumFactory());
                }
                this.causality.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getCausalityAssessment() {
            if (this.causalityAssessment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causalityAssessment");
                }
                if (Configuration.doAutoCreate()) {
                    this.causalityAssessment = new CodeableConcept();
                }
            }
            return this.causalityAssessment;
        }

        public boolean hasCausalityAssessment() {
            return this.causalityAssessment != null && !this.causalityAssessment.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausalityAssessment(CodeableConcept value) {
            this.causalityAssessment = value;
            return this;
        }

        public StringType getCausalityProductRelatednessElement() {
            if (this.causalityProductRelatedness == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causalityProductRelatedness");
                }
                if (Configuration.doAutoCreate()) {
                    this.causalityProductRelatedness = new StringType();
                }
            }
            return this.causalityProductRelatedness;
        }

        public boolean hasCausalityProductRelatednessElement() {
            return this.causalityProductRelatedness != null && !this.causalityProductRelatedness.isEmpty();
        }

        public boolean hasCausalityProductRelatedness() {
            return this.causalityProductRelatedness != null && !this.causalityProductRelatedness.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausalityProductRelatednessElement(StringType value) {
            this.causalityProductRelatedness = value;
            return this;
        }

        public String getCausalityProductRelatedness() {
            return this.causalityProductRelatedness == null ? null : (String)this.causalityProductRelatedness.getValue();
        }

        public AdverseEventSuspectEntityComponent setCausalityProductRelatedness(String value) {
            if (Utilities.noString((String)value)) {
                this.causalityProductRelatedness = null;
            } else {
                if (this.causalityProductRelatedness == null) {
                    this.causalityProductRelatedness = new StringType();
                }
                this.causalityProductRelatedness.setValue(value);
            }
            return this;
        }

        public CodeableConcept getCausalityMethod() {
            if (this.causalityMethod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causalityMethod");
                }
                if (Configuration.doAutoCreate()) {
                    this.causalityMethod = new CodeableConcept();
                }
            }
            return this.causalityMethod;
        }

        public boolean hasCausalityMethod() {
            return this.causalityMethod != null && !this.causalityMethod.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausalityMethod(CodeableConcept value) {
            this.causalityMethod = value;
            return this;
        }

        public Reference getCausalityAuthor() {
            if (this.causalityAuthor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causalityAuthor");
                }
                if (Configuration.doAutoCreate()) {
                    this.causalityAuthor = new Reference();
                }
            }
            return this.causalityAuthor;
        }

        public boolean hasCausalityAuthor() {
            return this.causalityAuthor != null && !this.causalityAuthor.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausalityAuthor(Reference value) {
            this.causalityAuthor = value;
            return this;
        }

        public Resource getCausalityAuthorTarget() {
            return this.causalityAuthorTarget;
        }

        public AdverseEventSuspectEntityComponent setCausalityAuthorTarget(Resource value) {
            this.causalityAuthorTarget = value;
            return this;
        }

        public CodeableConcept getCausalityResult() {
            if (this.causalityResult == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causalityResult");
                }
                if (Configuration.doAutoCreate()) {
                    this.causalityResult = new CodeableConcept();
                }
            }
            return this.causalityResult;
        }

        public boolean hasCausalityResult() {
            return this.causalityResult != null && !this.causalityResult.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausalityResult(CodeableConcept value) {
            this.causalityResult = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("instance", "Reference(Substance|Medication|MedicationAdministration|MedicationStatement|Device)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance));
            children.add(new Property("causality", "code", "causality1 | causality2.", 0, 1, this.causality));
            children.add(new Property("causalityAssessment", "CodeableConcept", "assess1 | assess2.", 0, 1, this.causalityAssessment));
            children.add(new Property("causalityProductRelatedness", "string", "AdverseEvent.suspectEntity.causalityProductRelatedness.", 0, 1, this.causalityProductRelatedness));
            children.add(new Property("causalityMethod", "CodeableConcept", "method1 | method2.", 0, 1, this.causalityMethod));
            children.add(new Property("causalityAuthor", "Reference(Practitioner|PractitionerRole)", "AdverseEvent.suspectEntity.causalityAuthor.", 0, 1, this.causalityAuthor));
            children.add(new Property("causalityResult", "CodeableConcept", "result1 | result2.", 0, 1, this.causalityResult));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 555127957: {
                    return new Property("instance", "Reference(Substance|Medication|MedicationAdministration|MedicationStatement|Device)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance);
                }
                case -1446450521: {
                    return new Property("causality", "code", "causality1 | causality2.", 0, 1, this.causality);
                }
                case 830609609: {
                    return new Property("causalityAssessment", "CodeableConcept", "assess1 | assess2.", 0, 1, this.causalityAssessment);
                }
                case -1983069286: {
                    return new Property("causalityProductRelatedness", "string", "AdverseEvent.suspectEntity.causalityProductRelatedness.", 0, 1, this.causalityProductRelatedness);
                }
                case -1320366488: {
                    return new Property("causalityMethod", "CodeableConcept", "method1 | method2.", 0, 1, this.causalityMethod);
                }
                case -1649139950: {
                    return new Property("causalityAuthor", "Reference(Practitioner|PractitionerRole)", "AdverseEvent.suspectEntity.causalityAuthor.", 0, 1, this.causalityAuthor);
                }
                case -1177238108: {
                    return new Property("causalityResult", "CodeableConcept", "result1 | result2.", 0, 1, this.causalityResult);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    Base[] baseArray;
                    if (this.instance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.instance;
                    }
                    return baseArray;
                }
                case -1446450521: {
                    Base[] baseArray;
                    if (this.causality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.causality;
                    }
                    return baseArray;
                }
                case 830609609: {
                    Base[] baseArray;
                    if (this.causalityAssessment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.causalityAssessment;
                    }
                    return baseArray;
                }
                case -1983069286: {
                    Base[] baseArray;
                    if (this.causalityProductRelatedness == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.causalityProductRelatedness;
                    }
                    return baseArray;
                }
                case -1320366488: {
                    Base[] baseArray;
                    if (this.causalityMethod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.causalityMethod;
                    }
                    return baseArray;
                }
                case -1649139950: {
                    Base[] baseArray;
                    if (this.causalityAuthor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.causalityAuthor;
                    }
                    return baseArray;
                }
                case -1177238108: {
                    Base[] baseArray;
                    if (this.causalityResult == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.causalityResult;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    this.instance = this.castToReference(value);
                    return value;
                }
                case -1446450521: {
                    value = new AdverseEventCausalityEnumFactory().fromType(this.castToCode(value));
                    this.causality = value;
                    return value;
                }
                case 830609609: {
                    this.causalityAssessment = this.castToCodeableConcept(value);
                    return value;
                }
                case -1983069286: {
                    this.causalityProductRelatedness = this.castToString(value);
                    return value;
                }
                case -1320366488: {
                    this.causalityMethod = this.castToCodeableConcept(value);
                    return value;
                }
                case -1649139950: {
                    this.causalityAuthor = this.castToReference(value);
                    return value;
                }
                case -1177238108: {
                    this.causalityResult = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("instance")) {
                this.instance = this.castToReference(value);
            } else if (name.equals("causality")) {
                value = new AdverseEventCausalityEnumFactory().fromType(this.castToCode(value));
                this.causality = value;
            } else if (name.equals("causalityAssessment")) {
                this.causalityAssessment = this.castToCodeableConcept(value);
            } else if (name.equals("causalityProductRelatedness")) {
                this.causalityProductRelatedness = this.castToString(value);
            } else if (name.equals("causalityMethod")) {
                this.causalityMethod = this.castToCodeableConcept(value);
            } else if (name.equals("causalityAuthor")) {
                this.causalityAuthor = this.castToReference(value);
            } else if (name.equals("causalityResult")) {
                this.causalityResult = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    return this.getInstance();
                }
                case -1446450521: {
                    return this.getCausalityElement();
                }
                case 830609609: {
                    return this.getCausalityAssessment();
                }
                case -1983069286: {
                    return this.getCausalityProductRelatednessElement();
                }
                case -1320366488: {
                    return this.getCausalityMethod();
                }
                case -1649139950: {
                    return this.getCausalityAuthor();
                }
                case -1177238108: {
                    return this.getCausalityResult();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    return new String[]{"Reference"};
                }
                case -1446450521: {
                    return new String[]{"code"};
                }
                case 830609609: {
                    return new String[]{"CodeableConcept"};
                }
                case -1983069286: {
                    return new String[]{"string"};
                }
                case -1320366488: {
                    return new String[]{"CodeableConcept"};
                }
                case -1649139950: {
                    return new String[]{"Reference"};
                }
                case -1177238108: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("instance")) {
                this.instance = new Reference();
                return this.instance;
            }
            if (name.equals("causality")) {
                throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.causality");
            }
            if (name.equals("causalityAssessment")) {
                this.causalityAssessment = new CodeableConcept();
                return this.causalityAssessment;
            }
            if (name.equals("causalityProductRelatedness")) {
                throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.causalityProductRelatedness");
            }
            if (name.equals("causalityMethod")) {
                this.causalityMethod = new CodeableConcept();
                return this.causalityMethod;
            }
            if (name.equals("causalityAuthor")) {
                this.causalityAuthor = new Reference();
                return this.causalityAuthor;
            }
            if (name.equals("causalityResult")) {
                this.causalityResult = new CodeableConcept();
                return this.causalityResult;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventSuspectEntityComponent copy() {
            AdverseEventSuspectEntityComponent dst = new AdverseEventSuspectEntityComponent();
            this.copyValues(dst);
            dst.instance = this.instance == null ? null : this.instance.copy();
            dst.causality = this.causality == null ? null : this.causality.copy();
            dst.causalityAssessment = this.causalityAssessment == null ? null : this.causalityAssessment.copy();
            dst.causalityProductRelatedness = this.causalityProductRelatedness == null ? null : this.causalityProductRelatedness.copy();
            dst.causalityMethod = this.causalityMethod == null ? null : this.causalityMethod.copy();
            dst.causalityAuthor = this.causalityAuthor == null ? null : this.causalityAuthor.copy();
            dst.causalityResult = this.causalityResult == null ? null : this.causalityResult.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSuspectEntityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityComponent o = (AdverseEventSuspectEntityComponent)other_;
            return AdverseEventSuspectEntityComponent.compareDeep(this.instance, o.instance, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causality, o.causality, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causalityAssessment, o.causalityAssessment, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causalityProductRelatedness, o.causalityProductRelatedness, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causalityMethod, o.causalityMethod, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causalityAuthor, o.causalityAuthor, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causalityResult, o.causalityResult, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSuspectEntityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityComponent o = (AdverseEventSuspectEntityComponent)other_;
            return AdverseEventSuspectEntityComponent.compareValues(this.causality, o.causality, true) && AdverseEventSuspectEntityComponent.compareValues(this.causalityProductRelatedness, o.causalityProductRelatedness, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.instance, this.causality, this.causalityAssessment, this.causalityProductRelatedness, this.causalityMethod, this.causalityAuthor, this.causalityResult});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.suspectEntity";
        }
    }

    public static class AdverseEventCausalityEnumFactory
    implements EnumFactory<AdverseEventCausality> {
        @Override
        public AdverseEventCausality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("causality1".equals(codeString)) {
                return AdverseEventCausality.CAUSALITY1;
            }
            if ("causality2".equals(codeString)) {
                return AdverseEventCausality.CAUSALITY2;
            }
            throw new IllegalArgumentException("Unknown AdverseEventCausality code '" + codeString + "'");
        }

        public Enumeration<AdverseEventCausality> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AdverseEventCausality>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("causality1".equals(codeString)) {
                return new Enumeration<AdverseEventCausality>(this, AdverseEventCausality.CAUSALITY1);
            }
            if ("causality2".equals(codeString)) {
                return new Enumeration<AdverseEventCausality>(this, AdverseEventCausality.CAUSALITY2);
            }
            throw new FHIRException("Unknown AdverseEventCausality code '" + codeString + "'");
        }

        @Override
        public String toCode(AdverseEventCausality code) {
            if (code == AdverseEventCausality.CAUSALITY1) {
                return "causality1";
            }
            if (code == AdverseEventCausality.CAUSALITY2) {
                return "causality2";
            }
            return "?";
        }

        @Override
        public String toSystem(AdverseEventCausality code) {
            return code.getSystem();
        }
    }

    public static enum AdverseEventCausality {
        CAUSALITY1,
        CAUSALITY2,
        NULL;


        public static AdverseEventCausality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("causality1".equals(codeString)) {
                return CAUSALITY1;
            }
            if ("causality2".equals(codeString)) {
                return CAUSALITY2;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AdverseEventCausality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CAUSALITY1: {
                    return "causality1";
                }
                case CAUSALITY2: {
                    return "causality2";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CAUSALITY1: {
                    return "http://hl7.org/fhir/adverse-event-causality";
                }
                case CAUSALITY2: {
                    return "http://hl7.org/fhir/adverse-event-causality";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CAUSALITY1: {
                    return "";
                }
                case CAUSALITY2: {
                    return "";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CAUSALITY1: {
                    return "causality1 placeholder";
                }
                case CAUSALITY2: {
                    return "causality2 placeholder";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AdverseEventCategoryEnumFactory
    implements EnumFactory<AdverseEventCategory> {
        @Override
        public AdverseEventCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("AE".equals(codeString)) {
                return AdverseEventCategory.AE;
            }
            if ("PAE".equals(codeString)) {
                return AdverseEventCategory.PAE;
            }
            throw new IllegalArgumentException("Unknown AdverseEventCategory code '" + codeString + "'");
        }

        public Enumeration<AdverseEventCategory> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AdverseEventCategory>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("AE".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.AE);
            }
            if ("PAE".equals(codeString)) {
                return new Enumeration<AdverseEventCategory>(this, AdverseEventCategory.PAE);
            }
            throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(AdverseEventCategory code) {
            if (code == AdverseEventCategory.AE) {
                return "AE";
            }
            if (code == AdverseEventCategory.PAE) {
                return "PAE";
            }
            return "?";
        }

        @Override
        public String toSystem(AdverseEventCategory code) {
            return code.getSystem();
        }
    }

    public static enum AdverseEventCategory {
        AE,
        PAE,
        NULL;


        public static AdverseEventCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("AE".equals(codeString)) {
                return AE;
            }
            if ("PAE".equals(codeString)) {
                return PAE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AE: {
                    return "AE";
                }
                case PAE: {
                    return "PAE";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AE: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case PAE: {
                    return "http://hl7.org/fhir/adverse-event-category";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AE: {
                    return "";
                }
                case PAE: {
                    return "";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AE: {
                    return "Adverse Event";
                }
                case PAE: {
                    return "Potential Adverse Event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

