/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ProcedureRequestStatus;

public class ProcedureRequestStatusEnumFactory
implements EnumFactory<ProcedureRequestStatus> {
    @Override
    public ProcedureRequestStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return ProcedureRequestStatus.PROPOSED;
        }
        if ("draft".equals(codeString)) {
            return ProcedureRequestStatus.DRAFT;
        }
        if ("requested".equals(codeString)) {
            return ProcedureRequestStatus.REQUESTED;
        }
        if ("received".equals(codeString)) {
            return ProcedureRequestStatus.RECEIVED;
        }
        if ("accepted".equals(codeString)) {
            return ProcedureRequestStatus.ACCEPTED;
        }
        if ("in-progress".equals(codeString)) {
            return ProcedureRequestStatus.INPROGRESS;
        }
        if ("completed".equals(codeString)) {
            return ProcedureRequestStatus.COMPLETED;
        }
        if ("suspended".equals(codeString)) {
            return ProcedureRequestStatus.SUSPENDED;
        }
        if ("rejected".equals(codeString)) {
            return ProcedureRequestStatus.REJECTED;
        }
        if ("aborted".equals(codeString)) {
            return ProcedureRequestStatus.ABORTED;
        }
        throw new IllegalArgumentException("Unknown ProcedureRequestStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ProcedureRequestStatus code) {
        if (code == ProcedureRequestStatus.PROPOSED) {
            return "proposed";
        }
        if (code == ProcedureRequestStatus.DRAFT) {
            return "draft";
        }
        if (code == ProcedureRequestStatus.REQUESTED) {
            return "requested";
        }
        if (code == ProcedureRequestStatus.RECEIVED) {
            return "received";
        }
        if (code == ProcedureRequestStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == ProcedureRequestStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == ProcedureRequestStatus.COMPLETED) {
            return "completed";
        }
        if (code == ProcedureRequestStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == ProcedureRequestStatus.REJECTED) {
            return "rejected";
        }
        if (code == ProcedureRequestStatus.ABORTED) {
            return "aborted";
        }
        return "?";
    }

    @Override
    public String toSystem(ProcedureRequestStatus code) {
        return code.getSystem();
    }
}

