/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.MedicationStatementCategory;

public class MedicationStatementCategoryEnumFactory
implements EnumFactory<MedicationStatementCategory> {
    @Override
    public MedicationStatementCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return MedicationStatementCategory.INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return MedicationStatementCategory.OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return MedicationStatementCategory.COMMUNITY;
        }
        if ("patientspecified".equals(codeString)) {
            return MedicationStatementCategory.PATIENTSPECIFIED;
        }
        throw new IllegalArgumentException("Unknown MedicationStatementCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationStatementCategory code) {
        if (code == MedicationStatementCategory.INPATIENT) {
            return "inpatient";
        }
        if (code == MedicationStatementCategory.OUTPATIENT) {
            return "outpatient";
        }
        if (code == MedicationStatementCategory.COMMUNITY) {
            return "community";
        }
        if (code == MedicationStatementCategory.PATIENTSPECIFIED) {
            return "patientspecified";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationStatementCategory code) {
        return code.getSystem();
    }
}

