/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ContractContentDerivative;

public class ContractContentDerivativeEnumFactory
implements EnumFactory<ContractContentDerivative> {
    @Override
    public ContractContentDerivative fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("registration".equals(codeString)) {
            return ContractContentDerivative.REGISTRATION;
        }
        if ("retrieval".equals(codeString)) {
            return ContractContentDerivative.RETRIEVAL;
        }
        if ("statement".equals(codeString)) {
            return ContractContentDerivative.STATEMENT;
        }
        if ("shareable".equals(codeString)) {
            return ContractContentDerivative.SHAREABLE;
        }
        throw new IllegalArgumentException("Unknown ContractContentDerivative code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractContentDerivative code) {
        if (code == ContractContentDerivative.REGISTRATION) {
            return "registration";
        }
        if (code == ContractContentDerivative.RETRIEVAL) {
            return "retrieval";
        }
        if (code == ContractContentDerivative.STATEMENT) {
            return "statement";
        }
        if (code == ContractContentDerivative.SHAREABLE) {
            return "shareable";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractContentDerivative code) {
        return code.getSystem();
    }
}

