/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ConceptProperties;

public class ConceptPropertiesEnumFactory
implements EnumFactory<ConceptProperties> {
    @Override
    public ConceptProperties fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inactive".equals(codeString)) {
            return ConceptProperties.INACTIVE;
        }
        if ("deprecated".equals(codeString)) {
            return ConceptProperties.DEPRECATED;
        }
        if ("notSelectable".equals(codeString)) {
            return ConceptProperties.NOTSELECTABLE;
        }
        if ("parent".equals(codeString)) {
            return ConceptProperties.PARENT;
        }
        if ("child".equals(codeString)) {
            return ConceptProperties.CHILD;
        }
        throw new IllegalArgumentException("Unknown ConceptProperties code '" + codeString + "'");
    }

    @Override
    public String toCode(ConceptProperties code) {
        if (code == ConceptProperties.INACTIVE) {
            return "inactive";
        }
        if (code == ConceptProperties.DEPRECATED) {
            return "deprecated";
        }
        if (code == ConceptProperties.NOTSELECTABLE) {
            return "notSelectable";
        }
        if (code == ConceptProperties.PARENT) {
            return "parent";
        }
        if (code == ConceptProperties.CHILD) {
            return "child";
        }
        return "?";
    }

    @Override
    public String toSystem(ConceptProperties code) {
        return code.getSystem();
    }
}

