/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CommunicationStatus;

public class CommunicationStatusEnumFactory
implements EnumFactory<CommunicationStatus> {
    @Override
    public CommunicationStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return CommunicationStatus.INPROGRESS;
        }
        if ("completed".equals(codeString)) {
            return CommunicationStatus.COMPLETED;
        }
        if ("suspended".equals(codeString)) {
            return CommunicationStatus.SUSPENDED;
        }
        if ("rejected".equals(codeString)) {
            return CommunicationStatus.REJECTED;
        }
        if ("failed".equals(codeString)) {
            return CommunicationStatus.FAILED;
        }
        throw new IllegalArgumentException("Unknown CommunicationStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(CommunicationStatus code) {
        if (code == CommunicationStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == CommunicationStatus.COMPLETED) {
            return "completed";
        }
        if (code == CommunicationStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == CommunicationStatus.REJECTED) {
            return "rejected";
        }
        if (code == CommunicationStatus.FAILED) {
            return "failed";
        }
        return "?";
    }

    @Override
    public String toSystem(CommunicationStatus code) {
        return code.getSystem();
    }
}

