/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3MapRelationship {
    BT,
    E,
    NT,
    NULL;


    public static V3MapRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("BT".equals(codeString)) {
            return BT;
        }
        if ("E".equals(codeString)) {
            return E;
        }
        if ("NT".equals(codeString)) {
            return NT;
        }
        throw new FHIRException("Unknown V3MapRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BT: {
                return "BT";
            }
            case E: {
                return "E";
            }
            case NT: {
                return "NT";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/MapRelationship";
    }

    public String getDefinition() {
        switch (this) {
            case BT: {
                return "The first concept is at a more abstract level than the second concept.  For example, Hepatitis is broader than Hepatitis A, and endocrine disease is broader than Diabetes Mellitus.  Broader than is the opposite of the narrower than relationship.";
            }
            case E: {
                return "The two concepts have identical meaning.";
            }
            case NT: {
                return "The first concept is at a more detailed level than the second concept.  For example, Pennicillin G is narrower than Pennicillin, and vellus hair is narrower than hair.  Narrower than is the opposite of broader than.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BT: {
                return "Broader Than";
            }
            case E: {
                return "Exact";
            }
            case NT: {
                return "Narrower Than";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

