/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ExProgramCode;

public class ExProgramCodeEnumFactory
implements EnumFactory<ExProgramCode> {
    @Override
    public ExProgramCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("as".equals(codeString)) {
            return ExProgramCode.AS;
        }
        if ("hd".equals(codeString)) {
            return ExProgramCode.HD;
        }
        if ("auscr".equals(codeString)) {
            return ExProgramCode.AUSCR;
        }
        if ("none".equals(codeString)) {
            return ExProgramCode.NONE;
        }
        throw new IllegalArgumentException("Unknown ExProgramCode code '" + codeString + "'");
    }

    @Override
    public String toCode(ExProgramCode code) {
        if (code == ExProgramCode.AS) {
            return "as";
        }
        if (code == ExProgramCode.HD) {
            return "hd";
        }
        if (code == ExProgramCode.AUSCR) {
            return "auscr";
        }
        if (code == ExProgramCode.NONE) {
            return "none";
        }
        return "?";
    }

    @Override
    public String toSystem(ExProgramCode code) {
        return code.getSystem();
    }
}

