/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionVerStatus {
    PROVISIONAL,
    DIFFERENTIAL,
    CONFIRMED,
    REFUTED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static ConditionVerStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("provisional".equals(codeString)) {
            return PROVISIONAL;
        }
        if ("differential".equals(codeString)) {
            return DIFFERENTIAL;
        }
        if ("confirmed".equals(codeString)) {
            return CONFIRMED;
        }
        if ("refuted".equals(codeString)) {
            return REFUTED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ConditionVerStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROVISIONAL: {
                return "provisional";
            }
            case DIFFERENTIAL: {
                return "differential";
            }
            case CONFIRMED: {
                return "confirmed";
            }
            case REFUTED: {
                return "refuted";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-ver-status";
    }

    public String getDefinition() {
        switch (this) {
            case PROVISIONAL: {
                return "This is a tentative diagnosis - still a candidate that is under consideration.";
            }
            case DIFFERENTIAL: {
                return "One of a set of potential (and typically mutually exclusive) diagnoses asserted to further guide the diagnostic process and preliminary treatment.";
            }
            case CONFIRMED: {
                return "There is sufficient diagnostic and/or clinical evidence to treat this as a confirmed condition.";
            }
            case REFUTED: {
                return "This condition has been ruled out by diagnostic and clinical evidence.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error and is not valid.";
            }
            case UNKNOWN: {
                return "The condition status is unknown.  Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROVISIONAL: {
                return "Provisional";
            }
            case DIFFERENTIAL: {
                return "Differential";
            }
            case CONFIRMED: {
                return "Confirmed";
            }
            case REFUTED: {
                return "Refuted";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

