/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CommunicationCategory {
    ALERT,
    NOTIFICATION,
    REMINDER,
    INSTRUCTION,
    NULL;


    public static CommunicationCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("alert".equals(codeString)) {
            return ALERT;
        }
        if ("notification".equals(codeString)) {
            return NOTIFICATION;
        }
        if ("reminder".equals(codeString)) {
            return REMINDER;
        }
        if ("instruction".equals(codeString)) {
            return INSTRUCTION;
        }
        throw new FHIRException("Unknown CommunicationCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ALERT: {
                return "alert";
            }
            case NOTIFICATION: {
                return "notification";
            }
            case REMINDER: {
                return "reminder";
            }
            case INSTRUCTION: {
                return "instruction";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/communication-category";
    }

    public String getDefinition() {
        switch (this) {
            case ALERT: {
                return "The communication conveys an alert.";
            }
            case NOTIFICATION: {
                return "The communication conveys a notification.";
            }
            case REMINDER: {
                return "The communication conveys a reminder.";
            }
            case INSTRUCTION: {
                return "The communication conveys instruction.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ALERT: {
                return "Alert";
            }
            case NOTIFICATION: {
                return "Notification";
            }
            case REMINDER: {
                return "Reminder";
            }
            case INSTRUCTION: {
                return "Instruction";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

