/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyClinicalStatus {
    ACTIVE,
    INACTIVE,
    RESOLVED,
    NULL;


    public static AllergyClinicalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        throw new FHIRException("Unknown AllergyClinicalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case RESOLVED: {
                return "resolved";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/allergy-clinical-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "An active record of a risk of a reaction to the identified substance.";
            }
            case INACTIVE: {
                return "An inactivated record of a risk of a reaction to the identified substance.";
            }
            case RESOLVED: {
                return "A reaction to the identified substance has been clinically reassessed by testing or re-exposure and considered to be resolved.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case RESOLVED: {
                return "Resolved";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

