/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventSeriousness {
    MILD,
    MODERATE,
    SEVERE,
    NULL;


    public static AdverseEventSeriousness fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Mild".equals(codeString)) {
            return MILD;
        }
        if ("Moderate".equals(codeString)) {
            return MODERATE;
        }
        if ("Severe".equals(codeString)) {
            return SEVERE;
        }
        throw new FHIRException("Unknown AdverseEventSeriousness code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MILD: {
                return "Mild";
            }
            case MODERATE: {
                return "Moderate";
            }
            case SEVERE: {
                return "Severe";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-seriousness";
    }

    public String getDefinition() {
        switch (this) {
            case MILD: {
                return "";
            }
            case MODERATE: {
                return "";
            }
            case SEVERE: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MILD: {
                return "Mild";
            }
            case MODERATE: {
                return "Moderate";
            }
            case SEVERE: {
                return "Severe";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

