/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConceptMap", profile="http://hl7.org/fhir/Profile/ConceptMap")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "copyright", "source[x]", "target[x]", "group"})
public class ConceptMap
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the concept map", formalDefinition="A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="purpose", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this concept map is defined", formalDefinition="Explaination of why this concept map is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.")
    protected MarkdownType copyright;
    @Child(name="source", type={UriType.class, ValueSet.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies the source of the concepts which are being mapped", formalDefinition="The source value set that specifies the concepts that are being mapped.")
    protected Type source;
    @Child(name="target", type={UriType.class, ValueSet.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Provides context to the mappings", formalDefinition="The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.")
    protected Type target;
    @Child(name="group", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Same source and target systems", formalDefinition="A group of mappings that all have the same source and target system.")
    protected List<ConceptMapGroupComponent> group;
    private static final long serialVersionUID = -2081872580L;
    @SearchParamDefinition(name="date", path="ConceptMap.date", description="The concept map publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ConceptMap.identifier", description="External identifier for the concept map", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="product", path="ConceptMap.group.element.target.product.property", description="Reference to property mapping depends on", type="uri")
    public static final String SP_PRODUCT = "product";
    public static final UriClientParam PRODUCT = new UriClientParam("product");
    @SearchParamDefinition(name="other", path="ConceptMap.group.unmapped.url", description="Canonical URL for other concept map", type="uri")
    public static final String SP_OTHER = "other";
    public static final UriClientParam OTHER = new UriClientParam("other");
    @SearchParamDefinition(name="target-system", path="ConceptMap.group.target", description="System of the target (if necessary)", type="uri")
    public static final String SP_TARGET_SYSTEM = "target-system";
    public static final UriClientParam TARGET_SYSTEM = new UriClientParam("target-system");
    @SearchParamDefinition(name="dependson", path="ConceptMap.group.element.target.dependsOn.property", description="Reference to property mapping depends on", type="uri")
    public static final String SP_DEPENDSON = "dependson";
    public static final UriClientParam DEPENDSON = new UriClientParam("dependson");
    @SearchParamDefinition(name="jurisdiction", path="ConceptMap.jurisdiction", description="Intended jurisdiction for the concept map", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="ConceptMap.description", description="The description of the concept map", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="source", path="ConceptMap.source.as(Reference)", description="Identifies the source of the concepts which are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("ConceptMap:source").toLocked();
    @SearchParamDefinition(name="title", path="ConceptMap.title", description="The human-friendly name of the concept map", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="ConceptMap.version", description="The business version of the concept map", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ConceptMap.url", description="The uri that identifies the concept map", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="target", path="ConceptMap.target.as(Reference)", description="Provides context to the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("ConceptMap:target").toLocked();
    @SearchParamDefinition(name="source-code", path="ConceptMap.group.element.code", description="Identifies element being mapped", type="token")
    public static final String SP_SOURCE_CODE = "source-code";
    public static final TokenClientParam SOURCE_CODE = new TokenClientParam("source-code");
    @SearchParamDefinition(name="source-uri", path="ConceptMap.source.as(Uri)", description="Identifies the source of the concepts which are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE_URI = "source-uri";
    public static final ReferenceClientParam SOURCE_URI = new ReferenceClientParam("source-uri");
    public static final Include INCLUDE_SOURCE_URI = new Include("ConceptMap:source-uri").toLocked();
    @SearchParamDefinition(name="name", path="ConceptMap.name", description="Computationally friendly name of the concept map", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ConceptMap.publisher", description="Name of the publisher of the concept map", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="source-system", path="ConceptMap.group.source", description="Code System (if value set crosses code systems)", type="uri")
    public static final String SP_SOURCE_SYSTEM = "source-system";
    public static final UriClientParam SOURCE_SYSTEM = new UriClientParam("source-system");
    @SearchParamDefinition(name="target-code", path="ConceptMap.group.element.target.code", description="Code that identifies the target element", type="token")
    public static final String SP_TARGET_CODE = "target-code";
    public static final TokenClientParam TARGET_CODE = new TokenClientParam("target-code");
    @SearchParamDefinition(name="status", path="ConceptMap.status", description="The current status of the concept map", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="target-uri", path="ConceptMap.target.as(Uri)", description="Provides context to the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET_URI = "target-uri";
    public static final ReferenceClientParam TARGET_URI = new ReferenceClientParam("target-uri");
    public static final Include INCLUDE_TARGET_URI = new Include("ConceptMap:target-uri").toLocked();

    public ConceptMap() {
    }

    public ConceptMap(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ConceptMap setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ConceptMap setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ConceptMap setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ConceptMap setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ConceptMap setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ConceptMap setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ConceptMap setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ConceptMap setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ConceptMap setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ConceptMap setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ConceptMap setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ConceptMap setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ConceptMap setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ConceptMap setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ConceptMap setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ConceptMap setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ConceptMap setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ConceptMap setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ConceptMap addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ConceptMap setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ConceptMap setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ConceptMap setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ConceptMap addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ConceptMap setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ConceptMap addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ConceptMap setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ConceptMap setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ConceptMap setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ConceptMap setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Type getSource() {
        return this.source;
    }

    public UriType getSourceUriType() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (UriType)this.source;
    }

    public boolean hasSourceUriType() {
        return this != null && this.source instanceof UriType;
    }

    public Reference getSourceReference() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Reference)this.source;
    }

    public boolean hasSourceReference() {
        return this != null && this.source instanceof Reference;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public ConceptMap setSource(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof UriType) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for ConceptMap.source[x]: " + value.fhirType());
        }
        this.source = value;
        return this;
    }

    public Type getTarget() {
        return this.target;
    }

    public UriType getTargetUriType() throws FHIRException {
        if (this.target == null) {
            return null;
        }
        if (!(this.target instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (UriType)this.target;
    }

    public boolean hasTargetUriType() {
        return this != null && this.target instanceof UriType;
    }

    public Reference getTargetReference() throws FHIRException {
        if (this.target == null) {
            return null;
        }
        if (!(this.target instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Reference)this.target;
    }

    public boolean hasTargetReference() {
        return this != null && this.target instanceof Reference;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public ConceptMap setTarget(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof UriType) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for ConceptMap.target[x]: " + value.fhirType());
        }
        this.target = value;
        return this;
    }

    public List<ConceptMapGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        return this.group;
    }

    public ConceptMap setGroup(List<ConceptMapGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (ConceptMapGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptMapGroupComponent addGroup() {
        ConceptMapGroupComponent t = new ConceptMapGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public ConceptMap addGroup(ConceptMapGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public ConceptMapGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this concept map is (or will be) published. The URL SHOULD include the major version of the concept map. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the concept map.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explaination of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright));
        children.add(new Property("source[x]", "uri|Reference(ValueSet)", "The source value set that specifies the concepts that are being mapped.", 0, 1, this.source));
        children.add(new Property("target[x]", "uri|Reference(ValueSet)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target));
        children.add(new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this concept map is (or will be) published. The URL SHOULD include the major version of the concept map. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the concept map.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright);
            }
            case -1698413947: {
                return new Property("source[x]", "uri|Reference(ValueSet)", "The source value set that specifies the concepts that are being mapped.", 0, 1, this.source);
            }
            case -896505829: {
                return new Property("source[x]", "uri|Reference(ValueSet)", "The source value set that specifies the concepts that are being mapped.", 0, 1, this.source);
            }
            case -1698419887: {
                return new Property("source[x]", "uri|Reference(ValueSet)", "The source value set that specifies the concepts that are being mapped.", 0, 1, this.source);
            }
            case -244259472: {
                return new Property("source[x]", "uri|Reference(ValueSet)", "The source value set that specifies the concepts that are being mapped.", 0, 1, this.source);
            }
            case -815579825: {
                return new Property("target[x]", "uri|Reference(ValueSet)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -880905839: {
                return new Property("target[x]", "uri|Reference(ValueSet)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -815585765: {
                return new Property("target[x]", "uri|Reference(ValueSet)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case 1259806906: {
                return new Property("target[x]", "uri|Reference(ValueSet)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case 98629247: {
                return new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.source;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.target;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case -896505829: {
                this.source = this.castToType(value);
                return value;
            }
            case -880905839: {
                this.target = this.castToType(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((ConceptMapGroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("source[x]")) {
            this.source = this.castToType(value);
        } else if (name.equals("target[x]")) {
            this.target = this.castToType(value);
        } else if (name.equals("group")) {
            this.getGroup().add((ConceptMapGroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -1698413947: {
                return this.getSource();
            }
            case -896505829: {
                return this.getSource();
            }
            case -815579825: {
                return this.getTarget();
            }
            case -880905839: {
                return this.getTarget();
            }
            case 98629247: {
                return this.addGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -896505829: {
                return new String[]{"uri", "Reference"};
            }
            case -880905839: {
                return new String[]{"uri", "Reference"};
            }
            case 98629247: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.copyright");
        }
        if (name.equals("sourceUri")) {
            this.source = new UriType();
            return this.source;
        }
        if (name.equals("sourceReference")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("targetUri")) {
            this.target = new UriType();
            return this.target;
        }
        if (name.equals("targetReference")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConceptMap";
    }

    @Override
    public ConceptMap copy() {
        ConceptMap dst = new ConceptMap();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.source = this.source == null ? null : this.source.copy();
        Type type = dst.target = this.target == null ? null : this.target.copy();
        if (this.group != null) {
            dst.group = new ArrayList<ConceptMapGroupComponent>();
            for (ConceptMapGroupComponent conceptMapGroupComponent : this.group) {
                dst.group.add(conceptMapGroupComponent.copy());
            }
        }
        return dst;
    }

    protected ConceptMap typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other_;
        return ConceptMap.compareDeep(this.identifier, o.identifier, true) && ConceptMap.compareDeep(this.purpose, o.purpose, true) && ConceptMap.compareDeep(this.copyright, o.copyright, true) && ConceptMap.compareDeep(this.source, o.source, true) && ConceptMap.compareDeep(this.target, o.target, true) && ConceptMap.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other_;
        return ConceptMap.compareValues(this.purpose, o.purpose, true) && ConceptMap.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.purpose, this.copyright, this.source, this.target, this.group});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConceptMap;
    }

    @Block
    public static class ConceptMapGroupUnmappedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="provided | fixed | other-map", formalDefinition="Defines which action to take if there is no match in the group. One of 3 actions is possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conceptmap-unmapped-mode")
        protected Enumeration<ConceptMapGroupUnmappedMode> mode;
        @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed code when mode = fixed", formalDefinition="The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="url", type={UriType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Canonical URL for other concept map", formalDefinition="The canonical URL of the map to use if this map contains no mapping.")
        protected UriType url;
        private static final long serialVersionUID = -482446774L;

        public ConceptMapGroupUnmappedComponent() {
        }

        public ConceptMapGroupUnmappedComponent(Enumeration<ConceptMapGroupUnmappedMode> mode) {
            this.mode = mode;
        }

        public Enumeration<ConceptMapGroupUnmappedMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<ConceptMapGroupUnmappedMode>(new ConceptMapGroupUnmappedModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setModeElement(Enumeration<ConceptMapGroupUnmappedMode> value) {
            this.mode = value;
            return this;
        }

        public ConceptMapGroupUnmappedMode getMode() {
            return this.mode == null ? null : (ConceptMapGroupUnmappedMode)((Object)this.mode.getValue());
        }

        public ConceptMapGroupUnmappedComponent setMode(ConceptMapGroupUnmappedMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<ConceptMapGroupUnmappedMode>(new ConceptMapGroupUnmappedModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptMapGroupUnmappedComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptMapGroupUnmappedComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public ConceptMapGroupUnmappedComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "Defines which action to take if there is no match in the group. One of 3 actions is possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode));
            children.add(new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property(ConceptMap.SP_URL, "uri", "The canonical URL of the map to use if this map contains no mapping.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "Defines which action to take if there is no match in the group. One of 3 actions is possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode);
                }
                case 3059181: {
                    return new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case 116079: {
                    return new Property(ConceptMap.SP_URL, "uri", "The canonical URL of the map to use if this map contains no mapping.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.display;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals(ConceptMap.SP_URL)) {
                this.url = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.mode");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.display");
            }
            if (name.equals(ConceptMap.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.url");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapGroupUnmappedComponent copy() {
            ConceptMapGroupUnmappedComponent dst = new ConceptMapGroupUnmappedComponent();
            this.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupUnmappedComponent)) {
                return false;
            }
            ConceptMapGroupUnmappedComponent o = (ConceptMapGroupUnmappedComponent)other_;
            return ConceptMapGroupUnmappedComponent.compareDeep(this.mode, o.mode, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.code, o.code, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.display, o.display, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupUnmappedComponent)) {
                return false;
            }
            ConceptMapGroupUnmappedComponent o = (ConceptMapGroupUnmappedComponent)other_;
            return ConceptMapGroupUnmappedComponent.compareValues(this.mode, o.mode, true) && ConceptMapGroupUnmappedComponent.compareValues(this.code, o.code, true) && ConceptMapGroupUnmappedComponent.compareValues(this.display, o.display, true) && ConceptMapGroupUnmappedComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.code, this.display, this.url});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.unmapped";
        }
    }

    @Block
    public static class OtherElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="property", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to property mapping depends on", formalDefinition="A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somwhere that is labeled to correspond with a code system property.")
        protected UriType property;
        @Child(name="system", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code System (if necessary)", formalDefinition="An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).")
        protected UriType system;
        @Child(name="code", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the referenced element", formalDefinition="Identity (code or path) or the element/item/ValueSet that the map depends on / refers to.")
        protected StringType code;
        @Child(name="display", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        private static final long serialVersionUID = 678887659L;

        public OtherElementComponent() {
        }

        public OtherElementComponent(UriType property, StringType code) {
            this.property = property;
            this.code = code;
        }

        public UriType getPropertyElement() {
            if (this.property == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.property");
                }
                if (Configuration.doAutoCreate()) {
                    this.property = new UriType();
                }
            }
            return this.property;
        }

        public boolean hasPropertyElement() {
            return this.property != null && !this.property.isEmpty();
        }

        public boolean hasProperty() {
            return this.property != null && !this.property.isEmpty();
        }

        public OtherElementComponent setPropertyElement(UriType value) {
            this.property = value;
            return this;
        }

        public String getProperty() {
            return this.property == null ? null : (String)this.property.getValue();
        }

        public OtherElementComponent setProperty(String value) {
            if (this.property == null) {
                this.property = new UriType();
            }
            this.property.setValue(value);
            return this;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public OtherElementComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public OtherElementComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public StringType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new StringType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OtherElementComponent setCodeElement(StringType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public OtherElementComponent setCode(String value) {
            if (this.code == null) {
                this.code = new StringType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public OtherElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public OtherElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("property", "uri", "A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somwhere that is labeled to correspond with a code system property.", 0, 1, this.property));
            children.add(new Property("system", "uri", "An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).", 0, 1, this.system));
            children.add(new Property("code", "string", "Identity (code or path) or the element/item/ValueSet that the map depends on / refers to.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -993141291: {
                    return new Property("property", "uri", "A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somwhere that is labeled to correspond with a code system property.", 0, 1, this.property);
                }
                case -887328209: {
                    return new Property("system", "uri", "An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).", 0, 1, this.system);
                }
                case 3059181: {
                    return new Property("code", "string", "Identity (code or path) or the element/item/ValueSet that the map depends on / refers to.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    Base[] baseArray;
                    if (this.property == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.property;
                    }
                    return baseArray;
                }
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.system;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.display;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    this.property = this.castToUri(value);
                    return value;
                }
                case -887328209: {
                    this.system = this.castToUri(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToString(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = this.castToUri(value);
            } else if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals("code")) {
                this.code = this.castToString(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return this.getPropertyElement();
                }
                case -887328209: {
                    return this.getSystemElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return new String[]{"uri"};
                }
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 3059181: {
                    return new String[]{"string"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.property");
            }
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.system");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.display");
            }
            return super.addChild(name);
        }

        @Override
        public OtherElementComponent copy() {
            OtherElementComponent dst = new OtherElementComponent();
            this.copyValues(dst);
            dst.property = this.property == null ? null : this.property.copy();
            dst.system = this.system == null ? null : this.system.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareDeep(this.property, o.property, true) && OtherElementComponent.compareDeep(this.system, o.system, true) && OtherElementComponent.compareDeep(this.code, o.code, true) && OtherElementComponent.compareDeep(this.display, o.display, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareValues(this.property, o.property, true) && OtherElementComponent.compareValues(this.system, o.system, true) && OtherElementComponent.compareValues(this.code, o.code, true) && OtherElementComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.property, this.system, this.code, this.display});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target.dependsOn";
        }
    }

    @Block
    public static class TargetElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies the target element", formalDefinition="Identity (code or path) or the element/item that the map refers to.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="equivalence", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="relatedto | equivalent | equal | wider | subsumes | narrower | specializes | inexact | unmatched | disjoint", formalDefinition="The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-map-equivalence")
        protected Enumeration<Enumerations.ConceptMapEquivalence> equivalence;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of status/issues in mapping", formalDefinition="A description of status/issues in mapping that conveys additional information not represented in  the structured data.")
        protected StringType comment;
        @Child(name="dependsOn", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other elements required for this mapping (from context)", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.")
        protected List<OtherElementComponent> dependsOn;
        @Child(name="product", type={OtherElementComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other concepts that this mapping also produces", formalDefinition="A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.")
        protected List<OtherElementComponent> product;
        private static final long serialVersionUID = -2008997477L;

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TargetElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TargetElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public TargetElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public TargetElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.ConceptMapEquivalence> getEquivalenceElement() {
            if (this.equivalence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.equivalence");
                }
                if (Configuration.doAutoCreate()) {
                    this.equivalence = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
                }
            }
            return this.equivalence;
        }

        public boolean hasEquivalenceElement() {
            return this.equivalence != null && !this.equivalence.isEmpty();
        }

        public boolean hasEquivalence() {
            return this.equivalence != null && !this.equivalence.isEmpty();
        }

        public TargetElementComponent setEquivalenceElement(Enumeration<Enumerations.ConceptMapEquivalence> value) {
            this.equivalence = value;
            return this;
        }

        public Enumerations.ConceptMapEquivalence getEquivalence() {
            return this.equivalence == null ? null : (Enumerations.ConceptMapEquivalence)((Object)this.equivalence.getValue());
        }

        public TargetElementComponent setEquivalence(Enumerations.ConceptMapEquivalence value) {
            if (value == null) {
                this.equivalence = null;
            } else {
                if (this.equivalence == null) {
                    this.equivalence = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
                }
                this.equivalence.setValue((Object)value);
            }
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public TargetElementComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public TargetElementComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public List<OtherElementComponent> getDependsOn() {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            return this.dependsOn;
        }

        public TargetElementComponent setDependsOn(List<OtherElementComponent> theDependsOn) {
            this.dependsOn = theDependsOn;
            return this;
        }

        public boolean hasDependsOn() {
            if (this.dependsOn == null) {
                return false;
            }
            for (OtherElementComponent item : this.dependsOn) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addDependsOn() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return t;
        }

        public TargetElementComponent addDependsOn(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return this;
        }

        public OtherElementComponent getDependsOnFirstRep() {
            if (this.getDependsOn().isEmpty()) {
                this.addDependsOn();
            }
            return this.getDependsOn().get(0);
        }

        public List<OtherElementComponent> getProduct() {
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            return this.product;
        }

        public TargetElementComponent setProduct(List<OtherElementComponent> theProduct) {
            this.product = theProduct;
            return this;
        }

        public boolean hasProduct() {
            if (this.product == null) {
                return false;
            }
            for (OtherElementComponent item : this.product) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addProduct() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return t;
        }

        public TargetElementComponent addProduct(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return this;
        }

        public OtherElementComponent getProductFirstRep() {
            if (this.getProduct().isEmpty()) {
                this.addProduct();
            }
            return this.getProduct().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("equivalence", "code", "The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).", 0, 1, this.equivalence));
            children.add(new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment));
            children.add(new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn));
            children.add(new Property(ConceptMap.SP_PRODUCT, "@ConceptMap.group.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.", 0, Integer.MAX_VALUE, this.product));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -15828692: {
                    return new Property("equivalence", "code", "The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).", 0, 1, this.equivalence);
                }
                case 950398559: {
                    return new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment);
                }
                case -1109214266: {
                    return new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn);
                }
                case -309474065: {
                    return new Property(ConceptMap.SP_PRODUCT, "@ConceptMap.group.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.", 0, Integer.MAX_VALUE, this.product);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -15828692: {
                    Base[] baseArray;
                    if (this.equivalence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.equivalence;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
                case -1109214266: {
                    return this.dependsOn == null ? new Base[]{} : this.dependsOn.toArray(new Base[this.dependsOn.size()]);
                }
                case -309474065: {
                    return this.product == null ? new Base[]{} : this.product.toArray(new Base[this.product.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
                case -15828692: {
                    value = new Enumerations.ConceptMapEquivalenceEnumFactory().fromType(this.castToCode(value));
                    this.equivalence = value;
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
                case -1109214266: {
                    this.getDependsOn().add((OtherElementComponent)((Object)value));
                    return value;
                }
                case -309474065: {
                    this.getProduct().add((OtherElementComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("equivalence")) {
                value = new Enumerations.ConceptMapEquivalenceEnumFactory().fromType(this.castToCode(value));
                this.equivalence = value;
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().add((OtherElementComponent)((Object)value));
            } else if (name.equals(ConceptMap.SP_PRODUCT)) {
                this.getProduct().add((OtherElementComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -15828692: {
                    return this.getEquivalenceElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case -1109214266: {
                    return this.addDependsOn();
                }
                case -309474065: {
                    return this.addProduct();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -15828692: {
                    return new String[]{"code"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case -1109214266: {
                    return new String[0];
                }
                case -309474065: {
                    return new String[]{"@ConceptMap.group.element.target.dependsOn"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.display");
            }
            if (name.equals("equivalence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.equivalence");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.comment");
            }
            if (name.equals("dependsOn")) {
                return this.addDependsOn();
            }
            if (name.equals(ConceptMap.SP_PRODUCT)) {
                return this.addProduct();
            }
            return super.addChild(name);
        }

        @Override
        public TargetElementComponent copy() {
            TargetElementComponent dst = new TargetElementComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.equivalence = this.equivalence == null ? null : this.equivalence.copy();
            StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
            if (this.dependsOn != null) {
                dst.dependsOn = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.dependsOn) {
                    dst.dependsOn.add(i.copy());
                }
            }
            if (this.product != null) {
                dst.product = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.product) {
                    dst.product.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareDeep(this.code, o.code, true) && TargetElementComponent.compareDeep(this.display, o.display, true) && TargetElementComponent.compareDeep(this.equivalence, o.equivalence, true) && TargetElementComponent.compareDeep(this.comment, o.comment, true) && TargetElementComponent.compareDeep(this.dependsOn, o.dependsOn, true) && TargetElementComponent.compareDeep(this.product, o.product, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareValues(this.code, o.code, true) && TargetElementComponent.compareValues(this.display, o.display, true) && TargetElementComponent.compareValues(this.equivalence, o.equivalence, true) && TargetElementComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.equivalence, this.comment, this.dependsOn, this.product});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target";
        }
    }

    @Block
    public static class SourceElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies element being mapped", formalDefinition="Identity (code or path) or the element/item being mapped.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="target", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concept in target system for element", formalDefinition="A concept from the target value set that this concept maps to.")
        protected List<TargetElementComponent> target;
        private static final long serialVersionUID = -1115258852L;

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SourceElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public SourceElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public SourceElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public SourceElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<TargetElementComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            return this.target;
        }

        public SourceElementComponent setTarget(List<TargetElementComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (TargetElementComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TargetElementComponent addTarget() {
            TargetElementComponent t = new TargetElementComponent();
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return t;
        }

        public SourceElementComponent addTarget(TargetElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return this;
        }

        public TargetElementComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property(ConceptMap.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -880905839: {
                    return new Property(ConceptMap.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((TargetElementComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.getTarget().add((TargetElementComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.display");
            }
            if (name.equals(ConceptMap.SP_TARGET)) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public SourceElementComponent copy() {
            SourceElementComponent dst = new SourceElementComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.target != null) {
                dst.target = new ArrayList<TargetElementComponent>();
                for (TargetElementComponent i : this.target) {
                    dst.target.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareDeep(this.code, o.code, true) && SourceElementComponent.compareDeep(this.display, o.display, true) && SourceElementComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareValues(this.code, o.code, true) && SourceElementComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.target});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element";
        }
    }

    @Block
    public static class ConceptMapGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code System (if value set crosses code systems)", formalDefinition="An absolute URI that identifies the Code System (if the source is a value set that crosses more than one code system).")
        protected UriType source;
        @Child(name="sourceVersion", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific version of the  code system", formalDefinition="The specific version of the code system, as determined by the code system authority.")
        protected StringType sourceVersion;
        @Child(name="target", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="System of the target (if necessary)", formalDefinition="An absolute URI that identifies the code system of the target code (if the target is a value set that cross code systems).")
        protected UriType target;
        @Child(name="targetVersion", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific version of the  code system", formalDefinition="The specific version of the code system, as determined by the code system authority.")
        protected StringType targetVersion;
        @Child(name="element", type={}, order=5, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Mappings for a concept from the source set", formalDefinition="Mappings for an individual concept in the source to one or more concepts in the target.")
        protected List<SourceElementComponent> element;
        @Child(name="unmapped", type={}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When no match in the mappings", formalDefinition="What to do when there is no match in the mappings in the group.")
        protected ConceptMapGroupUnmappedComponent unmapped;
        private static final long serialVersionUID = 1606357508L;

        public UriType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new UriType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ConceptMapGroupComponent setSourceElement(UriType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ConceptMapGroupComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new UriType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public StringType getSourceVersionElement() {
            if (this.sourceVersion == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.sourceVersion");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceVersion = new StringType();
                }
            }
            return this.sourceVersion;
        }

        public boolean hasSourceVersionElement() {
            return this.sourceVersion != null && !this.sourceVersion.isEmpty();
        }

        public boolean hasSourceVersion() {
            return this.sourceVersion != null && !this.sourceVersion.isEmpty();
        }

        public ConceptMapGroupComponent setSourceVersionElement(StringType value) {
            this.sourceVersion = value;
            return this;
        }

        public String getSourceVersion() {
            return this.sourceVersion == null ? null : (String)this.sourceVersion.getValue();
        }

        public ConceptMapGroupComponent setSourceVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceVersion = null;
            } else {
                if (this.sourceVersion == null) {
                    this.sourceVersion = new StringType();
                }
                this.sourceVersion.setValue(value);
            }
            return this;
        }

        public UriType getTargetElement() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new UriType();
                }
            }
            return this.target;
        }

        public boolean hasTargetElement() {
            return this.target != null && !this.target.isEmpty();
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ConceptMapGroupComponent setTargetElement(UriType value) {
            this.target = value;
            return this;
        }

        public String getTarget() {
            return this.target == null ? null : (String)this.target.getValue();
        }

        public ConceptMapGroupComponent setTarget(String value) {
            if (Utilities.noString((String)value)) {
                this.target = null;
            } else {
                if (this.target == null) {
                    this.target = new UriType();
                }
                this.target.setValue(value);
            }
            return this;
        }

        public StringType getTargetVersionElement() {
            if (this.targetVersion == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.targetVersion");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetVersion = new StringType();
                }
            }
            return this.targetVersion;
        }

        public boolean hasTargetVersionElement() {
            return this.targetVersion != null && !this.targetVersion.isEmpty();
        }

        public boolean hasTargetVersion() {
            return this.targetVersion != null && !this.targetVersion.isEmpty();
        }

        public ConceptMapGroupComponent setTargetVersionElement(StringType value) {
            this.targetVersion = value;
            return this;
        }

        public String getTargetVersion() {
            return this.targetVersion == null ? null : (String)this.targetVersion.getValue();
        }

        public ConceptMapGroupComponent setTargetVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.targetVersion = null;
            } else {
                if (this.targetVersion == null) {
                    this.targetVersion = new StringType();
                }
                this.targetVersion.setValue(value);
            }
            return this;
        }

        public List<SourceElementComponent> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            return this.element;
        }

        public ConceptMapGroupComponent setElement(List<SourceElementComponent> theElement) {
            this.element = theElement;
            return this;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (SourceElementComponent item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SourceElementComponent addElement() {
            SourceElementComponent t = new SourceElementComponent();
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return t;
        }

        public ConceptMapGroupComponent addElement(SourceElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return this;
        }

        public SourceElementComponent getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                this.addElement();
            }
            return this.getElement().get(0);
        }

        public ConceptMapGroupUnmappedComponent getUnmapped() {
            if (this.unmapped == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.unmapped");
                }
                if (Configuration.doAutoCreate()) {
                    this.unmapped = new ConceptMapGroupUnmappedComponent();
                }
            }
            return this.unmapped;
        }

        public boolean hasUnmapped() {
            return this.unmapped != null && !this.unmapped.isEmpty();
        }

        public ConceptMapGroupComponent setUnmapped(ConceptMapGroupUnmappedComponent value) {
            this.unmapped = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ConceptMap.SP_SOURCE, "uri", "An absolute URI that identifies the Code System (if the source is a value set that crosses more than one code system).", 0, 1, this.source));
            children.add(new Property("sourceVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.sourceVersion));
            children.add(new Property(ConceptMap.SP_TARGET, "uri", "An absolute URI that identifies the code system of the target code (if the target is a value set that cross code systems).", 0, 1, this.target));
            children.add(new Property("targetVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.targetVersion));
            children.add(new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element));
            children.add(new Property("unmapped", "", "What to do when there is no match in the mappings in the group.", 0, 1, this.unmapped));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property(ConceptMap.SP_SOURCE, "uri", "An absolute URI that identifies the Code System (if the source is a value set that crosses more than one code system).", 0, 1, this.source);
                }
                case 446171197: {
                    return new Property("sourceVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.sourceVersion);
                }
                case -880905839: {
                    return new Property(ConceptMap.SP_TARGET, "uri", "An absolute URI that identifies the code system of the target code (if the target is a value set that cross code systems).", 0, 1, this.target);
                }
                case -1639412217: {
                    return new Property("targetVersion", "string", "The specific version of the code system, as determined by the code system authority.", 0, 1, this.targetVersion);
                }
                case -1662836996: {
                    return new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element);
                }
                case -194857460: {
                    return new Property("unmapped", "", "What to do when there is no match in the mappings in the group.", 0, 1, this.unmapped);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case 446171197: {
                    Base[] baseArray;
                    if (this.sourceVersion == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sourceVersion;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.target;
                    }
                    return baseArray;
                }
                case -1639412217: {
                    Base[] baseArray;
                    if (this.targetVersion == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.targetVersion;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
                case -194857460: {
                    Base[] baseArray;
                    if (this.unmapped == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unmapped;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = this.castToUri(value);
                    return value;
                }
                case 446171197: {
                    this.sourceVersion = this.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.target = this.castToUri(value);
                    return value;
                }
                case -1639412217: {
                    this.targetVersion = this.castToString(value);
                    return value;
                }
                case -1662836996: {
                    this.getElement().add((SourceElementComponent)value);
                    return value;
                }
                case -194857460: {
                    this.unmapped = (ConceptMapGroupUnmappedComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ConceptMap.SP_SOURCE)) {
                this.source = this.castToUri(value);
            } else if (name.equals("sourceVersion")) {
                this.sourceVersion = this.castToString(value);
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.target = this.castToUri(value);
            } else if (name.equals("targetVersion")) {
                this.targetVersion = this.castToString(value);
            } else if (name.equals("element")) {
                this.getElement().add((SourceElementComponent)value);
            } else if (name.equals("unmapped")) {
                this.unmapped = (ConceptMapGroupUnmappedComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSourceElement();
                }
                case 446171197: {
                    return this.getSourceVersionElement();
                }
                case -880905839: {
                    return this.getTargetElement();
                }
                case -1639412217: {
                    return this.getTargetVersionElement();
                }
                case -1662836996: {
                    return this.addElement();
                }
                case -194857460: {
                    return this.getUnmapped();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"uri"};
                }
                case 446171197: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[]{"uri"};
                }
                case -1639412217: {
                    return new String[]{"string"};
                }
                case -1662836996: {
                    return new String[0];
                }
                case -194857460: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ConceptMap.SP_SOURCE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.source");
            }
            if (name.equals("sourceVersion")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.sourceVersion");
            }
            if (name.equals(ConceptMap.SP_TARGET)) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.target");
            }
            if (name.equals("targetVersion")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap.targetVersion");
            }
            if (name.equals("element")) {
                return this.addElement();
            }
            if (name.equals("unmapped")) {
                this.unmapped = new ConceptMapGroupUnmappedComponent();
                return this.unmapped;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapGroupComponent copy() {
            ConceptMapGroupComponent dst = new ConceptMapGroupComponent();
            this.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            dst.sourceVersion = this.sourceVersion == null ? null : this.sourceVersion.copy();
            dst.target = this.target == null ? null : this.target.copy();
            StringType stringType = dst.targetVersion = this.targetVersion == null ? null : this.targetVersion.copy();
            if (this.element != null) {
                dst.element = new ArrayList<SourceElementComponent>();
                for (SourceElementComponent i : this.element) {
                    dst.element.add(i.copy());
                }
            }
            dst.unmapped = this.unmapped == null ? null : this.unmapped.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupComponent)) {
                return false;
            }
            ConceptMapGroupComponent o = (ConceptMapGroupComponent)other_;
            return ConceptMapGroupComponent.compareDeep(this.source, o.source, true) && ConceptMapGroupComponent.compareDeep(this.sourceVersion, o.sourceVersion, true) && ConceptMapGroupComponent.compareDeep(this.target, o.target, true) && ConceptMapGroupComponent.compareDeep(this.targetVersion, o.targetVersion, true) && ConceptMapGroupComponent.compareDeep(this.element, o.element, true) && ConceptMapGroupComponent.compareDeep(this.unmapped, o.unmapped, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupComponent)) {
                return false;
            }
            ConceptMapGroupComponent o = (ConceptMapGroupComponent)other_;
            return ConceptMapGroupComponent.compareValues(this.source, o.source, true) && ConceptMapGroupComponent.compareValues(this.sourceVersion, o.sourceVersion, true) && ConceptMapGroupComponent.compareValues(this.target, o.target, true) && ConceptMapGroupComponent.compareValues(this.targetVersion, o.targetVersion, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.source, this.sourceVersion, this.target, this.targetVersion, this.element, this.unmapped});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group";
        }
    }

    public static class ConceptMapGroupUnmappedModeEnumFactory
    implements EnumFactory<ConceptMapGroupUnmappedMode> {
        @Override
        public ConceptMapGroupUnmappedMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("provided".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.PROVIDED;
            }
            if ("fixed".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.FIXED;
            }
            if ("other-map".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.OTHERMAP;
            }
            throw new IllegalArgumentException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        public Enumeration<ConceptMapGroupUnmappedMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provided".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.PROVIDED);
            }
            if ("fixed".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.FIXED);
            }
            if ("other-map".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.OTHERMAP);
            }
            throw new FHIRException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        @Override
        public String toCode(ConceptMapGroupUnmappedMode code) {
            if (code == ConceptMapGroupUnmappedMode.PROVIDED) {
                return "provided";
            }
            if (code == ConceptMapGroupUnmappedMode.FIXED) {
                return "fixed";
            }
            if (code == ConceptMapGroupUnmappedMode.OTHERMAP) {
                return "other-map";
            }
            return "?";
        }

        @Override
        public String toSystem(ConceptMapGroupUnmappedMode code) {
            return code.getSystem();
        }
    }

    public static enum ConceptMapGroupUnmappedMode {
        PROVIDED,
        FIXED,
        OTHERMAP,
        NULL;


        public static ConceptMapGroupUnmappedMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provided".equals(codeString)) {
                return PROVIDED;
            }
            if ("fixed".equals(codeString)) {
                return FIXED;
            }
            if ("other-map".equals(codeString)) {
                return OTHERMAP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROVIDED: {
                    return "provided";
                }
                case FIXED: {
                    return "fixed";
                }
                case OTHERMAP: {
                    return "other-map";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROVIDED: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case FIXED: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case OTHERMAP: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROVIDED: {
                    return "Use the code as provided in the $translate request";
                }
                case FIXED: {
                    return "Use the code explicitly provided in the group.unmapped";
                }
                case OTHERMAP: {
                    return "Use the map identified by the canonical URL in URL";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROVIDED: {
                    return "Provided Code";
                }
                case FIXED: {
                    return "Fixed Code";
                }
                case OTHERMAP: {
                    return "Other Map";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

