/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PlanDefinitionType {
    ORDERSET,
    PROTOCOL,
    ECARULE,
    NULL;


    public static PlanDefinitionType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("order-set".equals(codeString)) {
            return ORDERSET;
        }
        if ("protocol".equals(codeString)) {
            return PROTOCOL;
        }
        if ("eca-rule".equals(codeString)) {
            return ECARULE;
        }
        throw new FHIRException("Unknown PlanDefinitionType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORDERSET: {
                return "order-set";
            }
            case PROTOCOL: {
                return "protocol";
            }
            case ECARULE: {
                return "eca-rule";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/plan-definition-type";
    }

    public String getDefinition() {
        switch (this) {
            case ORDERSET: {
                return "A pre-defined and approved group of orders related to a particular clinical condition (e.g. hypertension treatment and monitoring) or stage of care (e.g. hospital admission to Coronary Care Unit). An order set is used as a checklist for the clinician when managing a patient with a specific condition. It is a structured collection of orders relevant to that condition and presented to the clinician in a computerized provider order entry (CPOE) system";
            }
            case PROTOCOL: {
                return "A set of activities that can be performed that have relationships in terms of order, pre-conditions, etc.";
            }
            case ECARULE: {
                return "A decision support rule of the form [on Event] if Condition then Action. It is intended to be a shareable, computable definition of actions that should be taken whenever some condition is met in response to a particular event or events";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORDERSET: {
                return "Order Set";
            }
            case PROTOCOL: {
                return "Protocol";
            }
            case ECARULE: {
                return "ECA Rule";
            }
        }
        return "?";
    }
}

