/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DocumentRelationshipType {
    REPLACES,
    TRANSFORMS,
    SIGNS,
    APPENDS,
    NULL;


    public static DocumentRelationshipType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("replaces".equals(codeString)) {
            return REPLACES;
        }
        if ("transforms".equals(codeString)) {
            return TRANSFORMS;
        }
        if ("signs".equals(codeString)) {
            return SIGNS;
        }
        if ("appends".equals(codeString)) {
            return APPENDS;
        }
        throw new FHIRException("Unknown DocumentRelationshipType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REPLACES: {
                return "replaces";
            }
            case TRANSFORMS: {
                return "transforms";
            }
            case SIGNS: {
                return "signs";
            }
            case APPENDS: {
                return "appends";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/document-relationship-type";
    }

    public String getDefinition() {
        switch (this) {
            case REPLACES: {
                return "This document logically replaces or supersedes the target document.";
            }
            case TRANSFORMS: {
                return "This document was generated by transforming the target document (e.g. format or language conversion).";
            }
            case SIGNS: {
                return "This document is a signature of the target document.";
            }
            case APPENDS: {
                return "This document adds additional information to the target document.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REPLACES: {
                return "Replaces";
            }
            case TRANSFORMS: {
                return "Transforms";
            }
            case SIGNS: {
                return "Signs";
            }
            case APPENDS: {
                return "Appends";
            }
        }
        return "?";
    }
}

