/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.BindingStrength;

public class BindingStrengthEnumFactory
implements EnumFactory<BindingStrength> {
    @Override
    public BindingStrength fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("required".equals(codeString)) {
            return BindingStrength.REQUIRED;
        }
        if ("extensible".equals(codeString)) {
            return BindingStrength.EXTENSIBLE;
        }
        if ("preferred".equals(codeString)) {
            return BindingStrength.PREFERRED;
        }
        if ("example".equals(codeString)) {
            return BindingStrength.EXAMPLE;
        }
        throw new IllegalArgumentException("Unknown BindingStrength code '" + codeString + "'");
    }

    @Override
    public String toCode(BindingStrength code) {
        if (code == BindingStrength.REQUIRED) {
            return "required";
        }
        if (code == BindingStrength.EXTENSIBLE) {
            return "extensible";
        }
        if (code == BindingStrength.PREFERRED) {
            return "preferred";
        }
        if (code == BindingStrength.EXAMPLE) {
            return "example";
        }
        return "?";
    }

    @Override
    public String toSystem(BindingStrength code) {
        return code.getSystem();
    }
}

