/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.ParserBase;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.utils.client.FHIRToolingClient;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.Utilities;

public class BatchLoader {
    public static void main(String[] args) throws IOException, Exception {
        if (args.length < 3) {
            System.out.println("Batch uploader takes 3 parameters in order: server base url, file/folder to upload, and batch size");
        } else {
            String server = args[0];
            String file = args[1];
            int size = Integer.parseInt(args[2]);
            if (file.endsWith(".xml")) {
                throw new FHIRException("Unimplemented file type " + file);
            }
            if (file.endsWith(".json")) {
                throw new FHIRException("Unimplemented file type " + file);
            }
            if (new File(file).isDirectory()) {
                BatchLoader.LoadDirectory(server, file, size);
            } else {
                throw new FHIRException("Unknown file type " + file);
            }
        }
    }

    private static void LoadDirectory(String server, String folder, int size) throws IOException, Exception {
        System.out.print("Connecting to " + server + ".. ");
        FHIRToolingClient client = new FHIRToolingClient(server);
        System.out.println("Done");
        IniFile ini = new IniFile(Utilities.path((String[])new String[]{folder, "batch-load-progress.ini"}));
        for (File f : new File(folder).listFiles()) {
            if (!f.getName().endsWith(".json") && !f.getName().endsWith(".xml") || ini.getBooleanProperty("finished", f.getName()).booleanValue()) continue;
            BatchLoader.sendFile(client, f, size, ini);
        }
    }

    private static void sendFile(FHIRToolingClient client, File f, int size, IniFile ini) throws FHIRFormatError, FileNotFoundException, IOException {
        long ms = System.currentTimeMillis();
        System.out.print("Loading " + f.getName() + ".. ");
        ParserBase parser = f.getName().endsWith(".json") ? new JsonParser() : new XmlParser();
        Resource res = parser.parse(new FileInputStream(f));
        System.out.println("  done: (" + Long.toString(System.currentTimeMillis() - ms) + " ms)");
        if (res instanceof Bundle) {
            int cursor;
            Bundle bnd = (Bundle)res;
            int n = cursor = ini.hasProperty("progress", f.getName()) ? ini.getIntegerProperty("progress", f.getName()) : 0;
            while (cursor < bnd.getEntry().size()) {
                Bundle bt = new Bundle();
                bt.setType(Bundle.BundleType.BATCH);
                bt.setId(UUID.randomUUID().toString().toLowerCase());
                for (int i = cursor; i < Math.min(bnd.getEntry().size(), cursor + size); ++i) {
                    Bundle.BundleEntryComponent be = bt.addEntry();
                    be.setResource(bnd.getEntry().get(i).getResource());
                    be.getRequest().setMethod(Bundle.HTTPVerb.PUT);
                    be.getRequest().setUrl(be.getResource().getResourceType().toString() + "/" + be.getResource().getId());
                }
                System.out.print(f.getName() + " (" + cursor + "/" + bnd.getEntry().size() + "): ");
                ms = System.currentTimeMillis();
                Bundle resp = client.transaction(bt);
                int ncursor = cursor + size;
                for (int i = 0; i < resp.getEntry().size(); ++i) {
                    Bundle.BundleEntryComponent t = resp.getEntry().get(i);
                    if (t.getResponse().getStatus().startsWith("2")) continue;
                    System.out.println("failed status at " + Integer.toString(i) + ": " + t.getResponse().getStatus());
                    ncursor = cursor + i - 1;
                    break;
                }
                cursor = ncursor;
                System.out.println("  .. done: (" + Long.toString(System.currentTimeMillis() - ms) + " ms) " + SimpleDateFormat.getInstance().format(new Date()));
                ini.setIntegerProperty("progress", f.getName(), cursor, null);
                ini.save();
            }
            ini.setBooleanProperty("finished", f.getName(), true, null);
            ini.save();
        } else {
            client.update(res);
            ini.setBooleanProperty("finished", f.getName(), true, null);
            ini.save();
        }
    }
}

