/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ObservationParamcode {
    AVERAGE,
    MAX,
    MIN,
    COUNT,
    NULL;


    public static ObservationParamcode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("average".equals(codeString)) {
            return AVERAGE;
        }
        if ("max".equals(codeString)) {
            return MAX;
        }
        if ("min".equals(codeString)) {
            return MIN;
        }
        if ("count".equals(codeString)) {
            return COUNT;
        }
        throw new FHIRException("Unknown ObservationParamcode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AVERAGE: {
                return "average";
            }
            case MAX: {
                return "max";
            }
            case MIN: {
                return "min";
            }
            case COUNT: {
                return "count";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/observation-paramcode";
    }

    public String getDefinition() {
        switch (this) {
            case AVERAGE: {
                return "The [mean](https://en.wikipedia.org/wiki/Arithmetic_mean)of N measurements over the stated period";
            }
            case MAX: {
                return "The [maximum](https://en.wikipedia.org/wiki/Maximal_element) value of N measurements over the stated period";
            }
            case MIN: {
                return "The [minimum](https://en.wikipedia.org/wiki/Minimal_element) value of N measurements over the stated period";
            }
            case COUNT: {
                return "The [number] of measurements over the stated period";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AVERAGE: {
                return "Average";
            }
            case MAX: {
                return "Maximum";
            }
            case MIN: {
                return "Minimum";
            }
            case COUNT: {
                return "Count";
            }
        }
        return "?";
    }
}

