/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum IdentifierUse {
    USUAL,
    OFFICIAL,
    TEMP,
    SECONDARY,
    NULL;


    public static IdentifierUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("usual".equals(codeString)) {
            return USUAL;
        }
        if ("official".equals(codeString)) {
            return OFFICIAL;
        }
        if ("temp".equals(codeString)) {
            return TEMP;
        }
        if ("secondary".equals(codeString)) {
            return SECONDARY;
        }
        throw new FHIRException("Unknown IdentifierUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case USUAL: {
                return "usual";
            }
            case OFFICIAL: {
                return "official";
            }
            case TEMP: {
                return "temp";
            }
            case SECONDARY: {
                return "secondary";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/identifier-use";
    }

    public String getDefinition() {
        switch (this) {
            case USUAL: {
                return "The identifier recommended for display and use in real-world interactions.";
            }
            case OFFICIAL: {
                return "The identifier considered to be most trusted for the identification of this item.";
            }
            case TEMP: {
                return "A temporary identifier.";
            }
            case SECONDARY: {
                return "An identifier that was assigned in secondary use - it serves to identify the object in a relative context, but cannot be consistently assigned to the same object again in a different context.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case USUAL: {
                return "Usual";
            }
            case OFFICIAL: {
                return "Official";
            }
            case TEMP: {
                return "Temp";
            }
            case SECONDARY: {
                return "Secondary";
            }
        }
        return "?";
    }
}

