/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ExPayeeResourceType;

public class ExPayeeResourceTypeEnumFactory
implements EnumFactory<ExPayeeResourceType> {
    @Override
    public ExPayeeResourceType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("organization".equals(codeString)) {
            return ExPayeeResourceType.ORGANIZATION;
        }
        if ("patient".equals(codeString)) {
            return ExPayeeResourceType.PATIENT;
        }
        if ("practitioner".equals(codeString)) {
            return ExPayeeResourceType.PRACTITIONER;
        }
        if ("relatedperson".equals(codeString)) {
            return ExPayeeResourceType.RELATEDPERSON;
        }
        throw new IllegalArgumentException("Unknown ExPayeeResourceType code '" + codeString + "'");
    }

    @Override
    public String toCode(ExPayeeResourceType code) {
        if (code == ExPayeeResourceType.ORGANIZATION) {
            return "organization";
        }
        if (code == ExPayeeResourceType.PATIENT) {
            return "patient";
        }
        if (code == ExPayeeResourceType.PRACTITIONER) {
            return "practitioner";
        }
        if (code == ExPayeeResourceType.RELATEDPERSON) {
            return "relatedperson";
        }
        return "?";
    }

    @Override
    public String toSystem(ExPayeeResourceType code) {
        return code.getSystem();
    }
}

