/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum BenefitNetwork {
    IN,
    OUT,
    NULL;


    public static BenefitNetwork fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in".equals(codeString)) {
            return IN;
        }
        if ("out".equals(codeString)) {
            return OUT;
        }
        throw new FHIRException("Unknown BenefitNetwork code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case IN: {
                return "in";
            }
            case OUT: {
                return "out";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/benefit-network";
    }

    public String getDefinition() {
        switch (this) {
            case IN: {
                return "Services rendered by a Network provider";
            }
            case OUT: {
                return "Services rendered by a provider who is not in the Network";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case IN: {
                return "In Network";
            }
            case OUT: {
                return "Out of Network";
            }
        }
        return "?";
    }
}

