/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.TriggerType;

public class TriggerTypeEnumFactory
implements EnumFactory<TriggerType> {
    @Override
    public TriggerType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("named-event".equals(codeString)) {
            return TriggerType.NAMEDEVENT;
        }
        if ("periodic".equals(codeString)) {
            return TriggerType.PERIODIC;
        }
        if ("data-added".equals(codeString)) {
            return TriggerType.DATAADDED;
        }
        if ("data-modified".equals(codeString)) {
            return TriggerType.DATAMODIFIED;
        }
        if ("data-removed".equals(codeString)) {
            return TriggerType.DATAREMOVED;
        }
        if ("data-accessed".equals(codeString)) {
            return TriggerType.DATAACCESSED;
        }
        if ("data-access-ended".equals(codeString)) {
            return TriggerType.DATAACCESSENDED;
        }
        throw new IllegalArgumentException("Unknown TriggerType code '" + codeString + "'");
    }

    @Override
    public String toCode(TriggerType code) {
        if (code == TriggerType.NULL) {
            return null;
        }
        if (code == TriggerType.NAMEDEVENT) {
            return "named-event";
        }
        if (code == TriggerType.PERIODIC) {
            return "periodic";
        }
        if (code == TriggerType.DATAADDED) {
            return "data-added";
        }
        if (code == TriggerType.DATAMODIFIED) {
            return "data-modified";
        }
        if (code == TriggerType.DATAREMOVED) {
            return "data-removed";
        }
        if (code == TriggerType.DATAACCESSED) {
            return "data-accessed";
        }
        if (code == TriggerType.DATAACCESSENDED) {
            return "data-access-ended";
        }
        return "?";
    }

    @Override
    public String toSystem(TriggerType code) {
        return code.getSystem();
    }
}

