/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SubscriptionTag {
    QUEUED,
    DELIVERED,
    NULL;


    public static SubscriptionTag fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("queued".equals(codeString)) {
            return QUEUED;
        }
        if ("delivered".equals(codeString)) {
            return DELIVERED;
        }
        throw new FHIRException("Unknown SubscriptionTag code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case QUEUED: {
                return "queued";
            }
            case DELIVERED: {
                return "delivered";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/subscription-tag";
    }

    public String getDefinition() {
        switch (this) {
            case QUEUED: {
                return "The message has been queued for processing on a destination systems.";
            }
            case DELIVERED: {
                return "The message has been delivered to its intended recipient.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case QUEUED: {
                return "Queued";
            }
            case DELIVERED: {
                return "Delivered";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

