/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum StructureDefinitionKind {
    DATATYPE,
    RESOURCE,
    LOGICAL,
    NULL;


    public static StructureDefinitionKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("datatype".equals(codeString)) {
            return DATATYPE;
        }
        if ("resource".equals(codeString)) {
            return RESOURCE;
        }
        if ("logical".equals(codeString)) {
            return LOGICAL;
        }
        throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DATATYPE: {
                return "datatype";
            }
            case RESOURCE: {
                return "resource";
            }
            case LOGICAL: {
                return "logical";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/structure-definition-kind";
    }

    public String getDefinition() {
        switch (this) {
            case DATATYPE: {
                return "A data type - either a primitive or complex structure that defines a set of data elements. These can be used throughout Resource and extension definitions.";
            }
            case RESOURCE: {
                return "A resource defined by the FHIR specification.";
            }
            case LOGICAL: {
                return "A logical model - a conceptual package of data that will be mapped to resources for implementation.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DATATYPE: {
                return "Data Type";
            }
            case RESOURCE: {
                return "Resource";
            }
            case LOGICAL: {
                return "Logical Model";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

