/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.SequenceType;

public class SequenceTypeEnumFactory
implements EnumFactory<SequenceType> {
    @Override
    public SequenceType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AA".equals(codeString)) {
            return SequenceType.AA;
        }
        if ("DNA".equals(codeString)) {
            return SequenceType.DNA;
        }
        if ("RNA".equals(codeString)) {
            return SequenceType.RNA;
        }
        throw new IllegalArgumentException("Unknown SequenceType code '" + codeString + "'");
    }

    @Override
    public String toCode(SequenceType code) {
        if (code == SequenceType.NULL) {
            return null;
        }
        if (code == SequenceType.AA) {
            return "AA";
        }
        if (code == SequenceType.DNA) {
            return "DNA";
        }
        if (code == SequenceType.RNA) {
            return "RNA";
        }
        return "?";
    }

    @Override
    public String toSystem(SequenceType code) {
        return code.getSystem();
    }
}

