/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.SearchParamType;

public class SearchParamTypeEnumFactory
implements EnumFactory<SearchParamType> {
    @Override
    public SearchParamType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("number".equals(codeString)) {
            return SearchParamType.NUMBER;
        }
        if ("date".equals(codeString)) {
            return SearchParamType.DATE;
        }
        if ("string".equals(codeString)) {
            return SearchParamType.STRING;
        }
        if ("token".equals(codeString)) {
            return SearchParamType.TOKEN;
        }
        if ("reference".equals(codeString)) {
            return SearchParamType.REFERENCE;
        }
        if ("composite".equals(codeString)) {
            return SearchParamType.COMPOSITE;
        }
        if ("quantity".equals(codeString)) {
            return SearchParamType.QUANTITY;
        }
        if ("uri".equals(codeString)) {
            return SearchParamType.URI;
        }
        throw new IllegalArgumentException("Unknown SearchParamType code '" + codeString + "'");
    }

    @Override
    public String toCode(SearchParamType code) {
        if (code == SearchParamType.NULL) {
            return null;
        }
        if (code == SearchParamType.NUMBER) {
            return "number";
        }
        if (code == SearchParamType.DATE) {
            return "date";
        }
        if (code == SearchParamType.STRING) {
            return "string";
        }
        if (code == SearchParamType.TOKEN) {
            return "token";
        }
        if (code == SearchParamType.REFERENCE) {
            return "reference";
        }
        if (code == SearchParamType.COMPOSITE) {
            return "composite";
        }
        if (code == SearchParamType.QUANTITY) {
            return "quantity";
        }
        if (code == SearchParamType.URI) {
            return "uri";
        }
        return "?";
    }

    @Override
    public String toSystem(SearchParamType code) {
        return code.getSystem();
    }
}

