/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.SearchModifierCode;

public class SearchModifierCodeEnumFactory
implements EnumFactory<SearchModifierCode> {
    @Override
    public SearchModifierCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("missing".equals(codeString)) {
            return SearchModifierCode.MISSING;
        }
        if ("exact".equals(codeString)) {
            return SearchModifierCode.EXACT;
        }
        if ("contains".equals(codeString)) {
            return SearchModifierCode.CONTAINS;
        }
        if ("not".equals(codeString)) {
            return SearchModifierCode.NOT;
        }
        if ("text".equals(codeString)) {
            return SearchModifierCode.TEXT;
        }
        if ("in".equals(codeString)) {
            return SearchModifierCode.IN;
        }
        if ("not-in".equals(codeString)) {
            return SearchModifierCode.NOTIN;
        }
        if ("below".equals(codeString)) {
            return SearchModifierCode.BELOW;
        }
        if ("above".equals(codeString)) {
            return SearchModifierCode.ABOVE;
        }
        if ("type".equals(codeString)) {
            return SearchModifierCode.TYPE;
        }
        throw new IllegalArgumentException("Unknown SearchModifierCode code '" + codeString + "'");
    }

    @Override
    public String toCode(SearchModifierCode code) {
        if (code == SearchModifierCode.NULL) {
            return null;
        }
        if (code == SearchModifierCode.MISSING) {
            return "missing";
        }
        if (code == SearchModifierCode.EXACT) {
            return "exact";
        }
        if (code == SearchModifierCode.CONTAINS) {
            return "contains";
        }
        if (code == SearchModifierCode.NOT) {
            return "not";
        }
        if (code == SearchModifierCode.TEXT) {
            return "text";
        }
        if (code == SearchModifierCode.IN) {
            return "in";
        }
        if (code == SearchModifierCode.NOTIN) {
            return "not-in";
        }
        if (code == SearchModifierCode.BELOW) {
            return "below";
        }
        if (code == SearchModifierCode.ABOVE) {
            return "above";
        }
        if (code == SearchModifierCode.TYPE) {
            return "type";
        }
        return "?";
    }

    @Override
    public String toSystem(SearchModifierCode code) {
        return code.getSystem();
    }
}

