/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QicoreAdverseeventCategory {
    BLOOD,
    DEVICE,
    FALL,
    INFECTION,
    SUBSTANCE,
    PERINATAL,
    ULCER,
    SURGERY,
    EMBOLISM,
    OTHER,
    NULL;


    public static QicoreAdverseeventCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("blood".equals(codeString)) {
            return BLOOD;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        if ("fall".equals(codeString)) {
            return FALL;
        }
        if ("infection".equals(codeString)) {
            return INFECTION;
        }
        if ("substance".equals(codeString)) {
            return SUBSTANCE;
        }
        if ("perinatal".equals(codeString)) {
            return PERINATAL;
        }
        if ("ulcer".equals(codeString)) {
            return ULCER;
        }
        if ("surgery".equals(codeString)) {
            return SURGERY;
        }
        if ("embolism".equals(codeString)) {
            return EMBOLISM;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown QicoreAdverseeventCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BLOOD: {
                return "blood";
            }
            case DEVICE: {
                return "device";
            }
            case FALL: {
                return "fall";
            }
            case INFECTION: {
                return "infection";
            }
            case SUBSTANCE: {
                return "substance";
            }
            case PERINATAL: {
                return "perinatal";
            }
            case ULCER: {
                return "ulcer";
            }
            case SURGERY: {
                return "surgery";
            }
            case EMBOLISM: {
                return "embolism";
            }
            case OTHER: {
                return "other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/qicore-adverseevent-category";
    }

    public String getDefinition() {
        switch (this) {
            case BLOOD: {
                return "Blood or Blood Product";
            }
            case DEVICE: {
                return "Device or Medical/Surgical Supply, including Health Information Technology (HIT)";
            }
            case FALL: {
                return "Fall by patient";
            }
            case INFECTION: {
                return "Healthcare-related infection";
            }
            case SUBSTANCE: {
                return "Medication or Other Substance";
            }
            case PERINATAL: {
                return "Perinatal";
            }
            case ULCER: {
                return "Pressure Ulcer";
            }
            case SURGERY: {
                return "Surgery or Anesthesia (includes invasive procedures)";
            }
            case EMBOLISM: {
                return "Venous Thromboembolism";
            }
            case OTHER: {
                return "Other (please specify)";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BLOOD: {
                return "Blood or Blood Product";
            }
            case DEVICE: {
                return "Device, Materials, or Information Technology";
            }
            case FALL: {
                return "Fall";
            }
            case INFECTION: {
                return "Healthcare-Related Infection";
            }
            case SUBSTANCE: {
                return "Medication or Other Substance";
            }
            case PERINATAL: {
                return "Perinatal";
            }
            case ULCER: {
                return "Pressure Ulcer";
            }
            case SURGERY: {
                return "Surgery or Anesthesia";
            }
            case EMBOLISM: {
                return "Venous Thromboembolism";
            }
            case OTHER: {
                return "Other (please specify)";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

