/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaProstateRadTumourType {
    ACINARVARIANT,
    PROSTATICDUCTALADENOCARCINOMA,
    NULL;


    public static NehtaNehtaProstateRadTumourType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("acinar_variant".equals(codeString)) {
            return ACINARVARIANT;
        }
        if ("prostatic_ductal_adenocarcinoma".equals(codeString)) {
            return PROSTATICDUCTALADENOCARCINOMA;
        }
        throw new FHIRException("Unknown NehtaNehtaProstateRadTumourType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACINARVARIANT: {
                return "acinar_variant";
            }
            case PROSTATICDUCTALADENOCARCINOMA: {
                return "prostatic_ductal_adenocarcinoma";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta--prostate-rad-tumour-type";
    }

    public String getDefinition() {
        switch (this) {
            case ACINARVARIANT: {
                return "Adenocarcinoma (Acinar variant eg, foamy, pseudohyperplastic)";
            }
            case PROSTATICDUCTALADENOCARCINOMA: {
                return "Prostatic ductal adenocarcinoma";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACINARVARIANT: {
                return "Adenocarcinoma (Acinar variant eg, foamy, pseudohyperplastic)";
            }
            case PROSTATICDUCTALADENOCARCINOMA: {
                return "Prostatic ductal adenocarcinoma";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

