/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MessageConformanceEventMode {
    SENDER,
    RECEIVER,
    NULL;


    public static MessageConformanceEventMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("sender".equals(codeString)) {
            return SENDER;
        }
        if ("receiver".equals(codeString)) {
            return RECEIVER;
        }
        throw new FHIRException("Unknown MessageConformanceEventMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SENDER: {
                return "sender";
            }
            case RECEIVER: {
                return "receiver";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/message-conformance-event-mode";
    }

    public String getDefinition() {
        switch (this) {
            case SENDER: {
                return "The application sends requests and receives responses.";
            }
            case RECEIVER: {
                return "The application receives requests and sends responses.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SENDER: {
                return "Sender";
            }
            case RECEIVER: {
                return "Receiver";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

