/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Fundsreserve {
    PATIENT,
    PROVIDER,
    NONE,
    NULL;


    public static Fundsreserve fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        if ("provider".equals(codeString)) {
            return PROVIDER;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown Fundsreserve code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENT: {
                return "patient";
            }
            case PROVIDER: {
                return "provider";
            }
            case NONE: {
                return "none";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/fundsreserve";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENT: {
                return "";
            }
            case PROVIDER: {
                return "";
            }
            case NONE: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENT: {
                return "patient";
            }
            case PROVIDER: {
                return "provider";
            }
            case NONE: {
                return "none";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

