/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.EncounterClass;

public class EncounterClassEnumFactory
implements EnumFactory<EncounterClass> {
    @Override
    public EncounterClass fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return EncounterClass.INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return EncounterClass.OUTPATIENT;
        }
        if ("ambulatory".equals(codeString)) {
            return EncounterClass.AMBULATORY;
        }
        if ("emergency".equals(codeString)) {
            return EncounterClass.EMERGENCY;
        }
        if ("home".equals(codeString)) {
            return EncounterClass.HOME;
        }
        if ("field".equals(codeString)) {
            return EncounterClass.FIELD;
        }
        if ("daytime".equals(codeString)) {
            return EncounterClass.DAYTIME;
        }
        if ("virtual".equals(codeString)) {
            return EncounterClass.VIRTUAL;
        }
        if ("other".equals(codeString)) {
            return EncounterClass.OTHER;
        }
        throw new IllegalArgumentException("Unknown EncounterClass code '" + codeString + "'");
    }

    @Override
    public String toCode(EncounterClass code) {
        if (code == EncounterClass.NULL) {
            return null;
        }
        if (code == EncounterClass.INPATIENT) {
            return "inpatient";
        }
        if (code == EncounterClass.OUTPATIENT) {
            return "outpatient";
        }
        if (code == EncounterClass.AMBULATORY) {
            return "ambulatory";
        }
        if (code == EncounterClass.EMERGENCY) {
            return "emergency";
        }
        if (code == EncounterClass.HOME) {
            return "home";
        }
        if (code == EncounterClass.FIELD) {
            return "field";
        }
        if (code == EncounterClass.DAYTIME) {
            return "daytime";
        }
        if (code == EncounterClass.VIRTUAL) {
            return "virtual";
        }
        if (code == EncounterClass.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(EncounterClass code) {
        return code.getSystem();
    }
}

