/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ConceptPropertyType;

public class ConceptPropertyTypeEnumFactory
implements EnumFactory<ConceptPropertyType> {
    @Override
    public ConceptPropertyType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("code".equals(codeString)) {
            return ConceptPropertyType.CODE;
        }
        if ("Coding".equals(codeString)) {
            return ConceptPropertyType.CODING;
        }
        if ("string".equals(codeString)) {
            return ConceptPropertyType.STRING;
        }
        if ("integer".equals(codeString)) {
            return ConceptPropertyType.INTEGER;
        }
        if ("boolean".equals(codeString)) {
            return ConceptPropertyType.BOOLEAN;
        }
        if ("dateTime".equals(codeString)) {
            return ConceptPropertyType.DATETIME;
        }
        throw new IllegalArgumentException("Unknown ConceptPropertyType code '" + codeString + "'");
    }

    @Override
    public String toCode(ConceptPropertyType code) {
        if (code == ConceptPropertyType.NULL) {
            return null;
        }
        if (code == ConceptPropertyType.CODE) {
            return "code";
        }
        if (code == ConceptPropertyType.CODING) {
            return "Coding";
        }
        if (code == ConceptPropertyType.STRING) {
            return "string";
        }
        if (code == ConceptPropertyType.INTEGER) {
            return "integer";
        }
        if (code == ConceptPropertyType.BOOLEAN) {
            return "boolean";
        }
        if (code == ConceptPropertyType.DATETIME) {
            return "dateTime";
        }
        return "?";
    }

    @Override
    public String toSystem(ConceptPropertyType code) {
        return code.getSystem();
    }
}

