/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionRelationshipType {
    BEFORE,
    AFTER,
    NULL;


    public static ActionRelationshipType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("before".equals(codeString)) {
            return BEFORE;
        }
        if ("after".equals(codeString)) {
            return AFTER;
        }
        throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BEFORE: {
                return "before";
            }
            case AFTER: {
                return "after";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-relationship-type";
    }

    public String getDefinition() {
        switch (this) {
            case BEFORE: {
                return "The action must be performed before the related action";
            }
            case AFTER: {
                return "The action must be performed after the related action";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BEFORE: {
                return "Before";
            }
            case AFTER: {
                return "After";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

