/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="PaymentNotice", profile="http://hl7.org/fhir/Profile/PaymentNotice")
public class PaymentNotice
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="ruleset", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="target", type={Identifier.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer or Regulatory body", formalDefinition="The Insurer who is target  of the request.")
    protected Type target;
    @Child(name="provider", type={Identifier.class, Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Type provider;
    @Child(name="organization", type={Identifier.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Type organization;
    @Child(name="request", type={Identifier.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Request reference", formalDefinition="Reference of resource to reverse.")
    protected Type request;
    @Child(name="response", type={Identifier.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Response reference", formalDefinition="Reference of response to resource to reverse.")
    protected Type response;
    @Child(name="paymentStatus", type={Coding.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Status of the payment", formalDefinition="The payment status, typically paid: payment sent, cleared: payment received.")
    protected Coding paymentStatus;
    @Child(name="statusDate", type={DateType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment or clearing date", formalDefinition="The date when the above payment action occurrred.")
    protected DateType statusDate;
    private static final long serialVersionUID = -771143315L;
    @SearchParamDefinition(name="paymentstatus", path="PaymentNotice.paymentStatus", description="The type of payment notice", type="token")
    public static final String SP_PAYMENTSTATUS = "paymentstatus";
    public static final TokenClientParam PAYMENTSTATUS = new TokenClientParam("paymentstatus");
    @SearchParamDefinition(name="statusdate", path="PaymentNotice.statusDate", description="The date of the payment action", type="date")
    public static final String SP_STATUSDATE = "statusdate";
    public static final DateClientParam STATUSDATE = new DateClientParam("statusdate");
    @SearchParamDefinition(name="created", path="PaymentNotice.created", description="Creation date fro the notice", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="requestidentifier", path="PaymentNotice.request.as(Identifier)", description="The Claim", type="token")
    public static final String SP_REQUESTIDENTIFIER = "requestidentifier";
    public static final TokenClientParam REQUESTIDENTIFIER = new TokenClientParam("requestidentifier");
    @SearchParamDefinition(name="providerreference", path="PaymentNotice.provider.as(Reference)", description="The reference to the provider", type="reference")
    public static final String SP_PROVIDERREFERENCE = "providerreference";
    public static final ReferenceClientParam PROVIDERREFERENCE = new ReferenceClientParam("providerreference");
    public static final Include INCLUDE_PROVIDERREFERENCE = new Include("PaymentNotice:providerreference").toLocked();
    @SearchParamDefinition(name="requestreference", path="PaymentNotice.request.as(Reference)", description="The Claim", type="reference")
    public static final String SP_REQUESTREFERENCE = "requestreference";
    public static final ReferenceClientParam REQUESTREFERENCE = new ReferenceClientParam("requestreference");
    public static final Include INCLUDE_REQUESTREFERENCE = new Include("PaymentNotice:requestreference").toLocked();
    @SearchParamDefinition(name="responsereference", path="PaymentNotice.response.as(Reference)", description="The ClaimResponse", type="reference")
    public static final String SP_RESPONSEREFERENCE = "responsereference";
    public static final ReferenceClientParam RESPONSEREFERENCE = new ReferenceClientParam("responsereference");
    public static final Include INCLUDE_RESPONSEREFERENCE = new Include("PaymentNotice:responsereference").toLocked();
    @SearchParamDefinition(name="organizationidentifier", path="PaymentNotice.organization.as(Identifier)", description="The organization who generated this resource", type="token")
    public static final String SP_ORGANIZATIONIDENTIFIER = "organizationidentifier";
    public static final TokenClientParam ORGANIZATIONIDENTIFIER = new TokenClientParam("organizationidentifier");
    @SearchParamDefinition(name="organizationreference", path="PaymentNotice.organization.as(Reference)", description="The organization who generated this resource", type="reference")
    public static final String SP_ORGANIZATIONREFERENCE = "organizationreference";
    public static final ReferenceClientParam ORGANIZATIONREFERENCE = new ReferenceClientParam("organizationreference");
    public static final Include INCLUDE_ORGANIZATIONREFERENCE = new Include("PaymentNotice:organizationreference").toLocked();
    @SearchParamDefinition(name="responseidentifier", path="PaymentNotice.response.as(Identifier)", description="The ClaimResponse", type="token")
    public static final String SP_RESPONSEIDENTIFIER = "responseidentifier";
    public static final TokenClientParam RESPONSEIDENTIFIER = new TokenClientParam("responseidentifier");
    @SearchParamDefinition(name="identifier", path="PaymentNotice.identifier", description="The business identifier of the notice", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="provideridentifier", path="PaymentNotice.provider.as(Identifier)", description="The reference to the provider", type="token")
    public static final String SP_PROVIDERIDENTIFIER = "provideridentifier";
    public static final TokenClientParam PROVIDERIDENTIFIER = new TokenClientParam("provideridentifier");

    public PaymentNotice() {
    }

    public PaymentNotice(Coding paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentNotice addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public PaymentNotice setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public PaymentNotice setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentNotice setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentNotice setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Type getTarget() {
        return this.target;
    }

    public Identifier getTargetIdentifier() throws FHIRException {
        if (!(this.target instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Identifier)this.target;
    }

    public boolean hasTargetIdentifier() {
        return this.target instanceof Identifier;
    }

    public Reference getTargetReference() throws FHIRException {
        if (!(this.target instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Reference)this.target;
    }

    public boolean hasTargetReference() {
        return this.target instanceof Reference;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public PaymentNotice setTarget(Type value) {
        this.target = value;
        return this;
    }

    public Type getProvider() {
        return this.provider;
    }

    public Identifier getProviderIdentifier() throws FHIRException {
        if (!(this.provider instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.provider.getClass().getName() + " was encountered");
        }
        return (Identifier)this.provider;
    }

    public boolean hasProviderIdentifier() {
        return this.provider instanceof Identifier;
    }

    public Reference getProviderReference() throws FHIRException {
        if (!(this.provider instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.provider.getClass().getName() + " was encountered");
        }
        return (Reference)this.provider;
    }

    public boolean hasProviderReference() {
        return this.provider instanceof Reference;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public PaymentNotice setProvider(Type value) {
        this.provider = value;
        return this;
    }

    public Type getOrganization() {
        return this.organization;
    }

    public Identifier getOrganizationIdentifier() throws FHIRException {
        if (!(this.organization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.organization;
    }

    public boolean hasOrganizationIdentifier() {
        return this.organization instanceof Identifier;
    }

    public Reference getOrganizationReference() throws FHIRException {
        if (!(this.organization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Reference)this.organization;
    }

    public boolean hasOrganizationReference() {
        return this.organization instanceof Reference;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PaymentNotice setOrganization(Type value) {
        this.organization = value;
        return this;
    }

    public Type getRequest() {
        return this.request;
    }

    public Identifier getRequestIdentifier() throws FHIRException {
        if (!(this.request instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Identifier)this.request;
    }

    public boolean hasRequestIdentifier() {
        return this.request instanceof Identifier;
    }

    public Reference getRequestReference() throws FHIRException {
        if (!(this.request instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Reference)this.request;
    }

    public boolean hasRequestReference() {
        return this.request instanceof Reference;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentNotice setRequest(Type value) {
        this.request = value;
        return this;
    }

    public Type getResponse() {
        return this.response;
    }

    public Identifier getResponseIdentifier() throws FHIRException {
        if (!(this.response instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.response.getClass().getName() + " was encountered");
        }
        return (Identifier)this.response;
    }

    public boolean hasResponseIdentifier() {
        return this.response instanceof Identifier;
    }

    public Reference getResponseReference() throws FHIRException {
        if (!(this.response instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.response.getClass().getName() + " was encountered");
        }
        return (Reference)this.response;
    }

    public boolean hasResponseReference() {
        return this.response instanceof Reference;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public PaymentNotice setResponse(Type value) {
        this.response = value;
        return this;
    }

    public Coding getPaymentStatus() {
        if (this.paymentStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.paymentStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentStatus = new Coding();
            }
        }
        return this.paymentStatus;
    }

    public boolean hasPaymentStatus() {
        return this.paymentStatus != null && !this.paymentStatus.isEmpty();
    }

    public PaymentNotice setPaymentStatus(Coding value) {
        this.paymentStatus = value;
        return this;
    }

    public DateType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public PaymentNotice setStatusDateElement(DateType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public PaymentNotice setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("target[x]", "Identifier|Reference(Organization)", "The Insurer who is target  of the request.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property("provider[x]", "Identifier|Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property("organization[x]", "Identifier|Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("request[x]", "Identifier|Reference(Any)", "Reference of resource to reverse.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("response[x]", "Identifier|Reference(Any)", "Reference of response to resource to reverse.", 0, Integer.MAX_VALUE, this.response));
        childrenList.add(new Property("paymentStatus", "Coding", "The payment status, typically paid: payment sent, cleared: payment received.", 0, Integer.MAX_VALUE, this.paymentStatus));
        childrenList.add(new Property("statusDate", "date", "The date when the above payment action occurrred.", 0, Integer.MAX_VALUE, this.statusDate));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1548678118: {
                Base[] baseArray;
                if (this.ruleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.ruleset;
                }
                return baseArray;
            }
            case 1089373397: {
                Base[] baseArray;
                if (this.originalRuleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.originalRuleset;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.created;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.target;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.provider;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.organization;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.request;
                }
                return baseArray;
            }
            case -340323263: {
                Base[] baseArray;
                if (this.response == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.response;
                }
                return baseArray;
            }
            case 1430704536: {
                Base[] baseArray;
                if (this.paymentStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.paymentStatus;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.statusDate;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1548678118: {
                this.ruleset = this.castToCoding(value);
                break;
            }
            case 1089373397: {
                this.originalRuleset = this.castToCoding(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case -880905839: {
                this.target = (Type)value;
                break;
            }
            case -987494927: {
                this.provider = (Type)value;
                break;
            }
            case 1178922291: {
                this.organization = (Type)value;
                break;
            }
            case 1095692943: {
                this.request = (Type)value;
                break;
            }
            case -340323263: {
                this.response = (Type)value;
                break;
            }
            case 1430704536: {
                this.paymentStatus = this.castToCoding(value);
                break;
            }
            case 247524032: {
                this.statusDate = this.castToDate(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("target[x]")) {
            this.target = (Type)value;
        } else if (name.equals("provider[x]")) {
            this.provider = (Type)value;
        } else if (name.equals("organization[x]")) {
            this.organization = (Type)value;
        } else if (name.equals("request[x]")) {
            this.request = (Type)value;
        } else if (name.equals("response[x]")) {
            this.response = (Type)value;
        } else if (name.equals("paymentStatus")) {
            this.paymentStatus = this.castToCoding(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = this.castToDate(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1548678118: {
                return this.getRuleset();
            }
            case 1089373397: {
                return this.getOriginalRuleset();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case -815579825: {
                return this.getTarget();
            }
            case 2064698607: {
                return this.getProvider();
            }
            case 1326483053: {
                return this.getOrganization();
            }
            case 37106577: {
                return this.getRequest();
            }
            case 1847549087: {
                return this.getResponse();
            }
            case 1430704536: {
                return this.getPaymentStatus();
            }
            case 247524032: {
                throw new FHIRException("Cannot make property statusDate as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property PaymentNotice.created");
        }
        if (name.equals("targetIdentifier")) {
            this.target = new Identifier();
            return this.target;
        }
        if (name.equals("targetReference")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals("providerIdentifier")) {
            this.provider = new Identifier();
            return this.provider;
        }
        if (name.equals("providerReference")) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("organizationIdentifier")) {
            this.organization = new Identifier();
            return this.organization;
        }
        if (name.equals("organizationReference")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestIdentifier")) {
            this.request = new Identifier();
            return this.request;
        }
        if (name.equals("requestReference")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("responseIdentifier")) {
            this.response = new Identifier();
            return this.response;
        }
        if (name.equals("responseReference")) {
            this.response = new Reference();
            return this.response;
        }
        if (name.equals("paymentStatus")) {
            this.paymentStatus = new Coding();
            return this.paymentStatus;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property PaymentNotice.statusDate");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentNotice";
    }

    @Override
    public PaymentNotice copy() {
        PaymentNotice dst = new PaymentNotice();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.response = this.response == null ? null : this.response.copy();
        dst.paymentStatus = this.paymentStatus == null ? null : this.paymentStatus.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        return dst;
    }

    protected PaymentNotice typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other;
        return PaymentNotice.compareDeep(this.identifier, o.identifier, true) && PaymentNotice.compareDeep(this.ruleset, o.ruleset, true) && PaymentNotice.compareDeep(this.originalRuleset, o.originalRuleset, true) && PaymentNotice.compareDeep(this.created, o.created, true) && PaymentNotice.compareDeep(this.target, o.target, true) && PaymentNotice.compareDeep(this.provider, o.provider, true) && PaymentNotice.compareDeep(this.organization, o.organization, true) && PaymentNotice.compareDeep(this.request, o.request, true) && PaymentNotice.compareDeep(this.response, o.response, true) && PaymentNotice.compareDeep(this.paymentStatus, o.paymentStatus, true) && PaymentNotice.compareDeep(this.statusDate, o.statusDate, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other;
        return PaymentNotice.compareValues(this.created, o.created, true) && PaymentNotice.compareValues(this.statusDate, o.statusDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.target != null && !this.target.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.request != null && !this.request.isEmpty() || this.response != null && !this.response.isEmpty() || this.paymentStatus != null && !this.paymentStatus.isEmpty() || this.statusDate != null && !this.statusDate.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentNotice;
    }
}

