/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CareTeam;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="EpisodeOfCare", profile="http://hl7.org/fhir/Profile/EpisodeOfCare")
public class EpisodeOfCare
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier(s) for the EpisodeOfCare", formalDefinition="Identifier(s) by which this EpisodeOfCare is known.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | waitlist | active | onhold | finished | cancelled", formalDefinition="planned | waitlist | active | onhold | finished | cancelled.")
    protected Enumeration<EpisodeOfCareStatus> status;
    @Child(name="statusHistory", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Past list of status codes", formalDefinition="The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).")
    protected List<EpisodeOfCareStatusHistoryComponent> statusHistory;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type/class  - e.g. specialist referral, disease management", formalDefinition="A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.")
    protected List<CodeableConcept> type;
    @Child(name="condition", type={Condition.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Conditions/problems/diagnoses this episode of care is for", formalDefinition="A list of conditions/problems/diagnoses that this episode of care is intended to be providing care for.")
    protected List<Reference> condition;
    protected List<Condition> conditionTarget;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient for this episode of care", formalDefinition="The patient that this EpisodeOfCare applies to.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="managingOrganization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that assumes care", formalDefinition="The organization that has assumed the specific responsibilities for the specified duration.")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval during responsibility is assumed", formalDefinition="The interval during which the managing organization assumes the defined responsibility.")
    protected Period period;
    @Child(name="referralRequest", type={ReferralRequest.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Originating Referral Request(s)", formalDefinition="Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.")
    protected List<Reference> referralRequest;
    protected List<ReferralRequest> referralRequestTarget;
    @Child(name="careManager", type={Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Care manager/care co-ordinator for the patient", formalDefinition="The practitioner that is the care manager/care co-ordinator for this patient.")
    protected Reference careManager;
    protected Practitioner careManagerTarget;
    @Child(name="team", type={CareTeam.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other practitioners facilitating this episode of care", formalDefinition="The list of practitioners that may be facilitating this episode of care for specific purposes.")
    protected List<Reference> team;
    protected List<CareTeam> teamTarget;
    private static final long serialVersionUID = 922419354L;
    @SearchParamDefinition(name="organization", path="EpisodeOfCare.managingOrganization", description="The organization that has assumed the specific responsibilities of this EpisodeOfCare", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("EpisodeOfCare:organization").toLocked();
    @SearchParamDefinition(name="patient", path="EpisodeOfCare.patient", description="Patient for this episode of care", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EpisodeOfCare:patient").toLocked();
    @SearchParamDefinition(name="condition", path="EpisodeOfCare.condition", description="Conditions/problems/diagnoses this episode of care is for", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("EpisodeOfCare:condition").toLocked();
    @SearchParamDefinition(name="status", path="EpisodeOfCare.status", description="The current status of the Episode of Care as provided (does not check the status history collection)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="care-manager", path="EpisodeOfCare.careManager", description="Care manager/care co-ordinator for the patient", type="reference")
    public static final String SP_CARE_MANAGER = "care-manager";
    public static final ReferenceClientParam CARE_MANAGER = new ReferenceClientParam("care-manager");
    public static final Include INCLUDE_CARE_MANAGER = new Include("EpisodeOfCare:care-manager").toLocked();
    @SearchParamDefinition(name="type", path="EpisodeOfCare.type", description="Type/class  - e.g. specialist referral, disease management", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="date", path="EpisodeOfCare.period", description="The provided date search value falls within the episode of care's period", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="incomingreferral", path="EpisodeOfCare.referralRequest", description="Incoming Referral Request", type="reference")
    public static final String SP_INCOMINGREFERRAL = "incomingreferral";
    public static final ReferenceClientParam INCOMINGREFERRAL = new ReferenceClientParam("incomingreferral");
    public static final Include INCLUDE_INCOMINGREFERRAL = new Include("EpisodeOfCare:incomingreferral").toLocked();
    @SearchParamDefinition(name="identifier", path="EpisodeOfCare.identifier", description="Identifier(s) for the EpisodeOfCare", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public EpisodeOfCare() {
    }

    public EpisodeOfCare(Enumeration<EpisodeOfCareStatus> status, Reference patient) {
        this.status = status;
        this.patient = patient;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EpisodeOfCare addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<EpisodeOfCareStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EpisodeOfCare setStatusElement(Enumeration<EpisodeOfCareStatus> value) {
        this.status = value;
        return this;
    }

    public EpisodeOfCareStatus getStatus() {
        return this.status == null ? null : (EpisodeOfCareStatus)((Object)this.status.getValue());
    }

    public EpisodeOfCare setStatus(EpisodeOfCareStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<EpisodeOfCareStatusHistoryComponent> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        return this.statusHistory;
    }

    public boolean hasStatusHistory() {
        if (this.statusHistory == null) {
            return false;
        }
        for (EpisodeOfCareStatusHistoryComponent item : this.statusHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EpisodeOfCareStatusHistoryComponent addStatusHistory() {
        EpisodeOfCareStatusHistoryComponent t = new EpisodeOfCareStatusHistoryComponent();
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return t;
    }

    public EpisodeOfCare addStatusHistory(EpisodeOfCareStatusHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public EpisodeOfCare addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public List<Reference> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<Reference>();
        }
        return this.condition;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (Reference item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCondition() {
        Reference t = new Reference();
        if (this.condition == null) {
            this.condition = new ArrayList<Reference>();
        }
        this.condition.add(t);
        return t;
    }

    public EpisodeOfCare addCondition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<Reference>();
        }
        this.condition.add(t);
        return this;
    }

    public List<Condition> getConditionTarget() {
        if (this.conditionTarget == null) {
            this.conditionTarget = new ArrayList<Condition>();
        }
        return this.conditionTarget;
    }

    public Condition addConditionTarget() {
        Condition r = new Condition();
        if (this.conditionTarget == null) {
            this.conditionTarget = new ArrayList<Condition>();
        }
        this.conditionTarget.add(r);
        return r;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public EpisodeOfCare setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public EpisodeOfCare setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public EpisodeOfCare setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public EpisodeOfCare setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public EpisodeOfCare setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getReferralRequest() {
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        return this.referralRequest;
    }

    public boolean hasReferralRequest() {
        if (this.referralRequest == null) {
            return false;
        }
        for (Reference item : this.referralRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReferralRequest() {
        Reference t = new Reference();
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        this.referralRequest.add(t);
        return t;
    }

    public EpisodeOfCare addReferralRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        this.referralRequest.add(t);
        return this;
    }

    public List<ReferralRequest> getReferralRequestTarget() {
        if (this.referralRequestTarget == null) {
            this.referralRequestTarget = new ArrayList<ReferralRequest>();
        }
        return this.referralRequestTarget;
    }

    public ReferralRequest addReferralRequestTarget() {
        ReferralRequest r = new ReferralRequest();
        if (this.referralRequestTarget == null) {
            this.referralRequestTarget = new ArrayList<ReferralRequest>();
        }
        this.referralRequestTarget.add(r);
        return r;
    }

    public Reference getCareManager() {
        if (this.careManager == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.careManager");
            }
            if (Configuration.doAutoCreate()) {
                this.careManager = new Reference();
            }
        }
        return this.careManager;
    }

    public boolean hasCareManager() {
        return this.careManager != null && !this.careManager.isEmpty();
    }

    public EpisodeOfCare setCareManager(Reference value) {
        this.careManager = value;
        return this;
    }

    public Practitioner getCareManagerTarget() {
        if (this.careManagerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.careManager");
            }
            if (Configuration.doAutoCreate()) {
                this.careManagerTarget = new Practitioner();
            }
        }
        return this.careManagerTarget;
    }

    public EpisodeOfCare setCareManagerTarget(Practitioner value) {
        this.careManagerTarget = value;
        return this;
    }

    public List<Reference> getTeam() {
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        return this.team;
    }

    public boolean hasTeam() {
        if (this.team == null) {
            return false;
        }
        for (Reference item : this.team) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTeam() {
        Reference t = new Reference();
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return t;
    }

    public EpisodeOfCare addTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return this;
    }

    public List<CareTeam> getTeamTarget() {
        if (this.teamTarget == null) {
            this.teamTarget = new ArrayList<CareTeam>();
        }
        return this.teamTarget;
    }

    public CareTeam addTeamTarget() {
        CareTeam r = new CareTeam();
        if (this.teamTarget == null) {
            this.teamTarget = new ArrayList<CareTeam>();
        }
        this.teamTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this EpisodeOfCare is known.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("statusHistory", "", "The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).", 0, Integer.MAX_VALUE, this.statusHistory));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_CONDITION, "Reference(Condition)", "A list of conditions/problems/diagnoses that this episode of care is intended to be providing care for.", 0, Integer.MAX_VALUE, this.condition));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient that this EpisodeOfCare applies to.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("managingOrganization", "Reference(Organization)", "The organization that has assumed the specific responsibilities for the specified duration.", 0, Integer.MAX_VALUE, this.managingOrganization));
        childrenList.add(new Property("period", "Period", "The interval during which the managing organization assumes the defined responsibility.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("referralRequest", "Reference(ReferralRequest)", "Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.", 0, Integer.MAX_VALUE, this.referralRequest));
        childrenList.add(new Property("careManager", "Reference(Practitioner)", "The practitioner that is the care manager/care co-ordinator for this patient.", 0, Integer.MAX_VALUE, this.careManager));
        childrenList.add(new Property("team", "Reference(CareTeam)", "The list of practitioners that may be facilitating this episode of care for specific purposes.", 0, Integer.MAX_VALUE, this.team));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -986695614: {
                return this.statusHistory == null ? new Base[]{} : this.statusHistory.toArray(new Base[this.statusHistory.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case -310299598: {
                return this.referralRequest == null ? new Base[]{} : this.referralRequest.toArray(new Base[this.referralRequest.size()]);
            }
            case -1147746468: {
                Base[] baseArray;
                if (this.careManager == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.careManager;
                }
                return baseArray;
            }
            case 3555933: {
                return this.team == null ? new Base[]{} : this.team.toArray(new Base[this.team.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -892481550: {
                this.status = new EpisodeOfCareStatusEnumFactory().fromType(value);
                break;
            }
            case -986695614: {
                this.getStatusHistory().add((EpisodeOfCareStatusHistoryComponent)value);
                break;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                break;
            }
            case -861311717: {
                this.getCondition().add(this.castToReference(value));
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -2058947787: {
                this.managingOrganization = this.castToReference(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -310299598: {
                this.getReferralRequest().add(this.castToReference(value));
                break;
            }
            case -1147746468: {
                this.careManager = this.castToReference(value);
                break;
            }
            case 3555933: {
                this.getTeam().add(this.castToReference(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new EpisodeOfCareStatusEnumFactory().fromType(value);
        } else if (name.equals("statusHistory")) {
            this.getStatusHistory().add((EpisodeOfCareStatusHistoryComponent)value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_CONDITION)) {
            this.getCondition().add(this.castToReference(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("referralRequest")) {
            this.getReferralRequest().add(this.castToReference(value));
        } else if (name.equals("careManager")) {
            this.careManager = this.castToReference(value);
        } else if (name.equals("team")) {
            this.getTeam().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -986695614: {
                return this.addStatusHistory();
            }
            case 3575610: {
                return this.addType();
            }
            case -861311717: {
                return this.addCondition();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -310299598: {
                return this.addReferralRequest();
            }
            case -1147746468: {
                return this.getCareManager();
            }
            case 3555933: {
                return this.addTeam();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property EpisodeOfCare.status");
        }
        if (name.equals("statusHistory")) {
            return this.addStatusHistory();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_CONDITION)) {
            return this.addCondition();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("referralRequest")) {
            return this.addReferralRequest();
        }
        if (name.equals("careManager")) {
            this.careManager = new Reference();
            return this.careManager;
        }
        if (name.equals("team")) {
            return this.addTeam();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EpisodeOfCare";
    }

    @Override
    public EpisodeOfCare copy() {
        EpisodeOfCare dst = new EpisodeOfCare();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EpisodeOfCareStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusHistory != null) {
            dst.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
            for (EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : this.statusHistory) {
                dst.statusHistory.add(episodeOfCareStatusHistoryComponent.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<Reference>();
            for (Reference reference : this.condition) {
                dst.condition.add(reference.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.referralRequest != null) {
            dst.referralRequest = new ArrayList<Reference>();
            for (Reference reference : this.referralRequest) {
                dst.referralRequest.add(reference.copy());
            }
        }
        Reference reference = dst.careManager = this.careManager == null ? null : this.careManager.copy();
        if (this.team != null) {
            dst.team = new ArrayList<Reference>();
            for (Reference reference2 : this.team) {
                dst.team.add(reference2.copy());
            }
        }
        return dst;
    }

    protected EpisodeOfCare typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof EpisodeOfCare)) {
            return false;
        }
        EpisodeOfCare o = (EpisodeOfCare)other;
        return EpisodeOfCare.compareDeep(this.identifier, o.identifier, true) && EpisodeOfCare.compareDeep(this.status, o.status, true) && EpisodeOfCare.compareDeep(this.statusHistory, o.statusHistory, true) && EpisodeOfCare.compareDeep(this.type, o.type, true) && EpisodeOfCare.compareDeep(this.condition, o.condition, true) && EpisodeOfCare.compareDeep(this.patient, o.patient, true) && EpisodeOfCare.compareDeep(this.managingOrganization, o.managingOrganization, true) && EpisodeOfCare.compareDeep(this.period, o.period, true) && EpisodeOfCare.compareDeep(this.referralRequest, o.referralRequest, true) && EpisodeOfCare.compareDeep(this.careManager, o.careManager, true) && EpisodeOfCare.compareDeep(this.team, o.team, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof EpisodeOfCare)) {
            return false;
        }
        EpisodeOfCare o = (EpisodeOfCare)other;
        return EpisodeOfCare.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.statusHistory != null && !this.statusHistory.isEmpty() || this.type != null && !this.type.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.managingOrganization != null && !this.managingOrganization.isEmpty() || this.period != null && !this.period.isEmpty() || this.referralRequest != null && !this.referralRequest.isEmpty() || this.careManager != null && !this.careManager.isEmpty() || this.team != null && !this.team.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EpisodeOfCare;
    }

    public static class EpisodeOfCareStatusEnumFactory
    implements EnumFactory<EpisodeOfCareStatus> {
        @Override
        public EpisodeOfCareStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EpisodeOfCareStatus.PLANNED;
            }
            if ("waitlist".equals(codeString)) {
                return EpisodeOfCareStatus.WAITLIST;
            }
            if ("active".equals(codeString)) {
                return EpisodeOfCareStatus.ACTIVE;
            }
            if ("onhold".equals(codeString)) {
                return EpisodeOfCareStatus.ONHOLD;
            }
            if ("finished".equals(codeString)) {
                return EpisodeOfCareStatus.FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return EpisodeOfCareStatus.CANCELLED;
            }
            throw new IllegalArgumentException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        public Enumeration<EpisodeOfCareStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.PLANNED);
            }
            if ("waitlist".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.WAITLIST);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ACTIVE);
            }
            if ("onhold".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ONHOLD);
            }
            if ("finished".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.FINISHED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.CANCELLED);
            }
            throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EpisodeOfCareStatus code) {
            if (code == EpisodeOfCareStatus.NULL) {
                return null;
            }
            if (code == EpisodeOfCareStatus.PLANNED) {
                return "planned";
            }
            if (code == EpisodeOfCareStatus.WAITLIST) {
                return "waitlist";
            }
            if (code == EpisodeOfCareStatus.ACTIVE) {
                return "active";
            }
            if (code == EpisodeOfCareStatus.ONHOLD) {
                return "onhold";
            }
            if (code == EpisodeOfCareStatus.FINISHED) {
                return "finished";
            }
            if (code == EpisodeOfCareStatus.CANCELLED) {
                return "cancelled";
            }
            return "?";
        }

        @Override
        public String toSystem(EpisodeOfCareStatus code) {
            return code.getSystem();
        }
    }

    public static enum EpisodeOfCareStatus {
        PLANNED,
        WAITLIST,
        ACTIVE,
        ONHOLD,
        FINISHED,
        CANCELLED,
        NULL;


        public static EpisodeOfCareStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("waitlist".equals(codeString)) {
                return WAITLIST;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("onhold".equals(codeString)) {
                return ONHOLD;
            }
            if ("finished".equals(codeString)) {
                return FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case WAITLIST: {
                    return "waitlist";
                }
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "onhold";
                }
                case FINISHED: {
                    return "finished";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case WAITLIST: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case FINISHED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "This episode of care is planned to start at the date specified in the period.start. During this status an organization may perform assessments to determine if they are eligible to receive services, or be organizing to make resources available to provide care services.";
                }
                case WAITLIST: {
                    return "This episode has been placed on a waitlist, pending the episode being made active (or cancelled).";
                }
                case ACTIVE: {
                    return "This episode of care is current.";
                }
                case ONHOLD: {
                    return "This episode of care is on hold, the organization has limited responsibility for the patient (such as while on respite).";
                }
                case FINISHED: {
                    return "This episode of care is finished at the organization is not expecting to be providing care to the patient. Can also be known as \"closed\", \"completed\" or other similar terms.";
                }
                case CANCELLED: {
                    return "The episode of care was cancelled, or withdrawn from service, often selected during the planned stage as the patient may have gone elsewhere, or the circumstances have changed and the organization is unable to provide the care. It indicates that services terminated outside the planned/expected workflow.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case WAITLIST: {
                    return "Waitlist";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case FINISHED: {
                    return "Finished";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class EpisodeOfCareStatusHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | waitlist | active | onhold | finished | cancelled", formalDefinition="planned | waitlist | active | onhold | finished | cancelled.")
        protected Enumeration<EpisodeOfCareStatus> status;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period for the status", formalDefinition="The period during this EpisodeOfCare that the specific status applied.")
        protected Period period;
        private static final long serialVersionUID = -1192432864L;

        public EpisodeOfCareStatusHistoryComponent() {
        }

        public EpisodeOfCareStatusHistoryComponent(Enumeration<EpisodeOfCareStatus> status, Period period) {
            this.status = status;
            this.period = period;
        }

        public Enumeration<EpisodeOfCareStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EpisodeOfCareStatusHistoryComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EpisodeOfCareStatusHistoryComponent setStatusElement(Enumeration<EpisodeOfCareStatus> value) {
            this.status = value;
            return this;
        }

        public EpisodeOfCareStatus getStatus() {
            return this.status == null ? null : (EpisodeOfCareStatus)((Object)this.status.getValue());
        }

        public EpisodeOfCareStatusHistoryComponent setStatus(EpisodeOfCareStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EpisodeOfCareStatusHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EpisodeOfCareStatusHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(EpisodeOfCare.SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("period", "Period", "The period during this EpisodeOfCare that the specific status applied.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = new EpisodeOfCareStatusEnumFactory().fromType(value);
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_STATUS)) {
                this.status = new EpisodeOfCareStatusEnumFactory().fromType(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    throw new FHIRException("Cannot make property status as it is not a complex type");
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a singleton property EpisodeOfCare.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EpisodeOfCareStatusHistoryComponent copy() {
            EpisodeOfCareStatusHistoryComponent dst = new EpisodeOfCareStatusHistoryComponent();
            this.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof EpisodeOfCareStatusHistoryComponent)) {
                return false;
            }
            EpisodeOfCareStatusHistoryComponent o = (EpisodeOfCareStatusHistoryComponent)other;
            return EpisodeOfCareStatusHistoryComponent.compareDeep(this.status, o.status, true) && EpisodeOfCareStatusHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof EpisodeOfCareStatusHistoryComponent)) {
                return false;
            }
            EpisodeOfCareStatusHistoryComponent o = (EpisodeOfCareStatusHistoryComponent)other;
            return EpisodeOfCareStatusHistoryComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.status != null && !this.status.isEmpty() || this.period != null && !this.period.isEmpty());
        }

        @Override
        public String fhirType() {
            return "EpisodeOfCare.statusHistory";
        }
    }
}

