/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcedureStatus {
    INPROGRESS,
    ABORTED,
    COMPLETED,
    ENTEREDINERROR,
    NULL;


    public static ProcedureStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("aborted".equals(codeString)) {
            return ABORTED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown ProcedureStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPROGRESS: {
                return "in-progress";
            }
            case ABORTED: {
                return "aborted";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/procedure-status";
    }

    public String getDefinition() {
        switch (this) {
            case INPROGRESS: {
                return "The procedure is still occurring.";
            }
            case ABORTED: {
                return "The procedure was terminated without completing successfully.";
            }
            case COMPLETED: {
                return "All actions involved in the procedure have taken place.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error and Is not valid.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPROGRESS: {
                return "In Progress";
            }
            case ABORTED: {
                return "Aboted";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

