/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ModuleMetadataType;

public class ModuleMetadataTypeEnumFactory
implements EnumFactory<ModuleMetadataType> {
    @Override
    public ModuleMetadataType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("module".equals(codeString)) {
            return ModuleMetadataType.MODULE;
        }
        if ("library".equals(codeString)) {
            return ModuleMetadataType.LIBRARY;
        }
        if ("decision-support-rule".equals(codeString)) {
            return ModuleMetadataType.DECISIONSUPPORTRULE;
        }
        if ("documentation-template".equals(codeString)) {
            return ModuleMetadataType.DOCUMENTATIONTEMPLATE;
        }
        if ("order-set".equals(codeString)) {
            return ModuleMetadataType.ORDERSET;
        }
        throw new IllegalArgumentException("Unknown ModuleMetadataType code '" + codeString + "'");
    }

    @Override
    public String toCode(ModuleMetadataType code) {
        if (code == ModuleMetadataType.NULL) {
            return null;
        }
        if (code == ModuleMetadataType.MODULE) {
            return "module";
        }
        if (code == ModuleMetadataType.LIBRARY) {
            return "library";
        }
        if (code == ModuleMetadataType.DECISIONSUPPORTRULE) {
            return "decision-support-rule";
        }
        if (code == ModuleMetadataType.DOCUMENTATIONTEMPLATE) {
            return "documentation-template";
        }
        if (code == ModuleMetadataType.ORDERSET) {
            return "order-set";
        }
        return "?";
    }

    @Override
    public String toSystem(ModuleMetadataType code) {
        return code.getSystem();
    }
}

