/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.DWebType;

public class DWebTypeEnumFactory
implements EnumFactory<DWebType> {
    @Override
    public DWebType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("WADO-RS".equals(codeString)) {
            return DWebType.WADORS;
        }
        if ("WADO-URI".equals(codeString)) {
            return DWebType.WADOURI;
        }
        if ("IID".equals(codeString)) {
            return DWebType.IID;
        }
        if ("WADO-WS".equals(codeString)) {
            return DWebType.WADOWS;
        }
        throw new IllegalArgumentException("Unknown DWebType code '" + codeString + "'");
    }

    @Override
    public String toCode(DWebType code) {
        if (code == DWebType.NULL) {
            return null;
        }
        if (code == DWebType.WADORS) {
            return "WADO-RS";
        }
        if (code == DWebType.WADOURI) {
            return "WADO-URI";
        }
        if (code == DWebType.IID) {
            return "IID";
        }
        if (code == DWebType.WADOWS) {
            return "WADO-WS";
        }
        return "?";
    }

    @Override
    public String toSystem(DWebType code) {
        return code.getSystem();
    }
}

