/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Age;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.ClinicalImpression;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DiagnosticReport;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Condition", profile="http://hl7.org/fhir/Profile/Condition")
public class Condition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this condition", formalDefinition="This records identifiers associated with this condition that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who has the condition?", formalDefinition="Indicates the patient who the condition record is associated with.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="encounter", type={Encounter.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter when condition first asserted", formalDefinition="Encounter during which the condition was first asserted.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="asserter", type={Practitioner.class, Patient.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person who asserts this condition", formalDefinition="Individual who is making the condition statement.")
    protected Reference asserter;
    protected Resource asserterTarget;
    @Child(name="dateRecorded", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When first entered", formalDefinition="A date, when  the Condition statement was documented.")
    protected DateType dateRecorded;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the condition, problem or diagnosis", formalDefinition="Identification of the condition, problem or diagnosis.")
    protected CodeableConcept code;
    @Child(name="category", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complaint | symptom | finding | diagnosis", formalDefinition="A category assigned to the condition.")
    protected CodeableConcept category;
    @Child(name="clinicalStatus", type={CodeType.class}, order=7, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | relapse | remission | resolved", formalDefinition="The clinical status of the condition.")
    protected CodeType clinicalStatus;
    @Child(name="verificationStatus", type={CodeType.class}, order=8, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="provisional | differential | confirmed | refuted | entered-in-error | unknown", formalDefinition="The verification status to support the clinical status of the condition.")
    protected Enumeration<ConditionVerificationStatus> verificationStatus;
    @Child(name="severity", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subjective severity of condition", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    protected CodeableConcept severity;
    @Child(name="onset", type={DateTimeType.class, Age.class, Period.class, Range.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Estimated or actual date,  date-time, or age", formalDefinition="Estimated or actual date or date-time  the condition began, in the opinion of the clinician.")
    protected Type onset;
    @Child(name="abatement", type={DateTimeType.class, Age.class, BooleanType.class, Period.class, Range.class, StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If/when in resolution/remission", formalDefinition="The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.")
    protected Type abatement;
    @Child(name="stage", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Stage/grade, usually assessed formally", formalDefinition="Clinical stage or grade of a condition. May include formal severity assessments.")
    protected ConditionStageComponent stage;
    @Child(name="evidence", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting evidence", formalDefinition="Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed.")
    protected List<ConditionEvidenceComponent> evidence;
    @Child(name="bodySite", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where this condition manifests itself.")
    protected List<CodeableConcept> bodySite;
    @Child(name="notes", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information about the Condition", formalDefinition="Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.")
    protected StringType notes;
    private static final long serialVersionUID = -341227215L;
    @SearchParamDefinition(name="date-recorded", path="Condition.dateRecorded", description="A date, when the Condition statement was documented", type="date")
    public static final String SP_DATE_RECORDED = "date-recorded";
    public static final DateClientParam DATE_RECORDED = new DateClientParam("date-recorded");
    @SearchParamDefinition(name="asserter", path="Condition.asserter", description="Person who asserts this condition", type="reference")
    public static final String SP_ASSERTER = "asserter";
    public static final ReferenceClientParam ASSERTER = new ReferenceClientParam("asserter");
    public static final Include INCLUDE_ASSERTER = new Include("Condition:asserter").toLocked();
    @SearchParamDefinition(name="onset", path="Condition.onset.as(dateTime) | Condition.onset.as(Period)", description="Date related onsets (dateTime and Period)", type="date")
    public static final String SP_ONSET = "onset";
    public static final DateClientParam ONSET = new DateClientParam("onset");
    @SearchParamDefinition(name="evidence", path="Condition.evidence.code", description="Manifestation/symptom", type="token")
    public static final String SP_EVIDENCE = "evidence";
    public static final TokenClientParam EVIDENCE = new TokenClientParam("evidence");
    @SearchParamDefinition(name="body-site", path="Condition.bodySite", description="Anatomical location, if relevant", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");
    @SearchParamDefinition(name="onset-info", path="Condition.onset.as(boolean) | Condition.onset.as(Quantity) | Condition.onset.as(Range) | Condition.onset.as(string)", description="Other onsets (boolean, age, range, string)", type="string")
    public static final String SP_ONSET_INFO = "onset-info";
    public static final StringClientParam ONSET_INFO = new StringClientParam("onset-info");
    @SearchParamDefinition(name="severity", path="Condition.severity", description="The severity of the condition", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="code", path="Condition.code", description="Code for the condition", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="encounter", path="Condition.encounter", description="Encounter when condition first asserted", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Condition:encounter").toLocked();
    @SearchParamDefinition(name="stage", path="Condition.stage.summary", description="Simple summary (disease specific)", type="token")
    public static final String SP_STAGE = "stage";
    public static final TokenClientParam STAGE = new TokenClientParam("stage");
    @SearchParamDefinition(name="category", path="Condition.category", description="The category of the condition", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="patient", path="Condition.patient", description="Who has the condition?", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Condition:patient").toLocked();
    @SearchParamDefinition(name="clinicalstatus", path="Condition.clinicalStatus", description="The clinical status of the condition", type="token")
    public static final String SP_CLINICALSTATUS = "clinicalstatus";
    public static final TokenClientParam CLINICALSTATUS = new TokenClientParam("clinicalstatus");
    @SearchParamDefinition(name="identifier", path="Condition.identifier", description="A unique identifier of the condition record", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Condition() {
    }

    public Condition(Reference patient, CodeableConcept code, Enumeration<ConditionVerificationStatus> verificationStatus) {
        this.patient = patient;
        this.code = code;
        this.verificationStatus = verificationStatus;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Condition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Condition setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Condition setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Condition setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Condition setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getAsserter() {
        if (this.asserter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.asserter");
            }
            if (Configuration.doAutoCreate()) {
                this.asserter = new Reference();
            }
        }
        return this.asserter;
    }

    public boolean hasAsserter() {
        return this.asserter != null && !this.asserter.isEmpty();
    }

    public Condition setAsserter(Reference value) {
        this.asserter = value;
        return this;
    }

    public Resource getAsserterTarget() {
        return this.asserterTarget;
    }

    public Condition setAsserterTarget(Resource value) {
        this.asserterTarget = value;
        return this;
    }

    public DateType getDateRecordedElement() {
        if (this.dateRecorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.dateRecorded");
            }
            if (Configuration.doAutoCreate()) {
                this.dateRecorded = new DateType();
            }
        }
        return this.dateRecorded;
    }

    public boolean hasDateRecordedElement() {
        return this.dateRecorded != null && !this.dateRecorded.isEmpty();
    }

    public boolean hasDateRecorded() {
        return this.dateRecorded != null && !this.dateRecorded.isEmpty();
    }

    public Condition setDateRecordedElement(DateType value) {
        this.dateRecorded = value;
        return this;
    }

    public Date getDateRecorded() {
        return this.dateRecorded == null ? null : (Date)this.dateRecorded.getValue();
    }

    public Condition setDateRecorded(Date value) {
        if (value == null) {
            this.dateRecorded = null;
        } else {
            if (this.dateRecorded == null) {
                this.dateRecorded = new DateType();
            }
            this.dateRecorded.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Condition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Condition setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeType getClinicalStatusElement() {
        if (this.clinicalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.clinicalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalStatus = new CodeType();
            }
        }
        return this.clinicalStatus;
    }

    public boolean hasClinicalStatusElement() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public boolean hasClinicalStatus() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public Condition setClinicalStatusElement(CodeType value) {
        this.clinicalStatus = value;
        return this;
    }

    public String getClinicalStatus() {
        return this.clinicalStatus == null ? null : (String)this.clinicalStatus.getValue();
    }

    public Condition setClinicalStatus(String value) {
        if (Utilities.noString((String)value)) {
            this.clinicalStatus = null;
        } else {
            if (this.clinicalStatus == null) {
                this.clinicalStatus = new CodeType();
            }
            this.clinicalStatus.setValue(value);
        }
        return this;
    }

    public Enumeration<ConditionVerificationStatus> getVerificationStatusElement() {
        if (this.verificationStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.verificationStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.verificationStatus = new Enumeration<ConditionVerificationStatus>(new ConditionVerificationStatusEnumFactory());
            }
        }
        return this.verificationStatus;
    }

    public boolean hasVerificationStatusElement() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public boolean hasVerificationStatus() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public Condition setVerificationStatusElement(Enumeration<ConditionVerificationStatus> value) {
        this.verificationStatus = value;
        return this;
    }

    public ConditionVerificationStatus getVerificationStatus() {
        return this.verificationStatus == null ? null : (ConditionVerificationStatus)((Object)this.verificationStatus.getValue());
    }

    public Condition setVerificationStatus(ConditionVerificationStatus value) {
        if (this.verificationStatus == null) {
            this.verificationStatus = new Enumeration<ConditionVerificationStatus>(new ConditionVerificationStatusEnumFactory());
        }
        this.verificationStatus.setValue((Object)value);
        return this;
    }

    public CodeableConcept getSeverity() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new CodeableConcept();
            }
        }
        return this.severity;
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public Condition setSeverity(CodeableConcept value) {
        this.severity = value;
        return this;
    }

    public Type getOnset() {
        return this.onset;
    }

    public DateTimeType getOnsetDateTimeType() throws FHIRException {
        if (!(this.onset instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.onset;
    }

    public boolean hasOnsetDateTimeType() {
        return this.onset instanceof DateTimeType;
    }

    public Age getOnsetAge() throws FHIRException {
        if (!(this.onset instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Age)this.onset;
    }

    public boolean hasOnsetAge() {
        return this.onset instanceof Age;
    }

    public Period getOnsetPeriod() throws FHIRException {
        if (!(this.onset instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Period)this.onset;
    }

    public boolean hasOnsetPeriod() {
        return this.onset instanceof Period;
    }

    public Range getOnsetRange() throws FHIRException {
        if (!(this.onset instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Range)this.onset;
    }

    public boolean hasOnsetRange() {
        return this.onset instanceof Range;
    }

    public StringType getOnsetStringType() throws FHIRException {
        if (!(this.onset instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (StringType)this.onset;
    }

    public boolean hasOnsetStringType() {
        return this.onset instanceof StringType;
    }

    public boolean hasOnset() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public Condition setOnset(Type value) {
        this.onset = value;
        return this;
    }

    public Type getAbatement() {
        return this.abatement;
    }

    public DateTimeType getAbatementDateTimeType() throws FHIRException {
        if (!(this.abatement instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.abatement;
    }

    public boolean hasAbatementDateTimeType() {
        return this.abatement instanceof DateTimeType;
    }

    public Age getAbatementAge() throws FHIRException {
        if (!(this.abatement instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Age)this.abatement;
    }

    public boolean hasAbatementAge() {
        return this.abatement instanceof Age;
    }

    public BooleanType getAbatementBooleanType() throws FHIRException {
        if (!(this.abatement instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.abatement;
    }

    public boolean hasAbatementBooleanType() {
        return this.abatement instanceof BooleanType;
    }

    public Period getAbatementPeriod() throws FHIRException {
        if (!(this.abatement instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Period)this.abatement;
    }

    public boolean hasAbatementPeriod() {
        return this.abatement instanceof Period;
    }

    public Range getAbatementRange() throws FHIRException {
        if (!(this.abatement instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Range)this.abatement;
    }

    public boolean hasAbatementRange() {
        return this.abatement instanceof Range;
    }

    public StringType getAbatementStringType() throws FHIRException {
        if (!(this.abatement instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (StringType)this.abatement;
    }

    public boolean hasAbatementStringType() {
        return this.abatement instanceof StringType;
    }

    public boolean hasAbatement() {
        return this.abatement != null && !this.abatement.isEmpty();
    }

    public Condition setAbatement(Type value) {
        this.abatement = value;
        return this;
    }

    public ConditionStageComponent getStage() {
        if (this.stage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.stage");
            }
            if (Configuration.doAutoCreate()) {
                this.stage = new ConditionStageComponent();
            }
        }
        return this.stage;
    }

    public boolean hasStage() {
        return this.stage != null && !this.stage.isEmpty();
    }

    public Condition setStage(ConditionStageComponent value) {
        this.stage = value;
        return this;
    }

    public List<ConditionEvidenceComponent> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidenceComponent>();
        }
        return this.evidence;
    }

    public boolean hasEvidence() {
        if (this.evidence == null) {
            return false;
        }
        for (ConditionEvidenceComponent item : this.evidence) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionEvidenceComponent addEvidence() {
        ConditionEvidenceComponent t = new ConditionEvidenceComponent();
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidenceComponent>();
        }
        this.evidence.add(t);
        return t;
    }

    public Condition addEvidence(ConditionEvidenceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidenceComponent>();
        }
        this.evidence.add(t);
        return this;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public Condition addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public StringType getNotesElement() {
        if (this.notes == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.notes");
            }
            if (Configuration.doAutoCreate()) {
                this.notes = new StringType();
            }
        }
        return this.notes;
    }

    public boolean hasNotesElement() {
        return this.notes != null && !this.notes.isEmpty();
    }

    public boolean hasNotes() {
        return this.notes != null && !this.notes.isEmpty();
    }

    public Condition setNotesElement(StringType value) {
        this.notes = value;
        return this;
    }

    public String getNotes() {
        return this.notes == null ? null : (String)this.notes.getValue();
    }

    public Condition setNotes(String value) {
        if (Utilities.noString((String)value)) {
            this.notes = null;
        } else {
            if (this.notes == null) {
                this.notes = new StringType();
            }
            this.notes.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this condition that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Indicates the patient who the condition record is associated with.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Encounter during which the condition was first asserted.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_ASSERTER, "Reference(Practitioner|Patient)", "Individual who is making the condition statement.", 0, Integer.MAX_VALUE, this.asserter));
        childrenList.add(new Property("dateRecorded", "date", "A date, when  the Condition statement was documented.", 0, Integer.MAX_VALUE, this.dateRecorded));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "A category assigned to the condition.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property("clinicalStatus", SP_CODE, "The clinical status of the condition.", 0, Integer.MAX_VALUE, this.clinicalStatus));
        childrenList.add(new Property("verificationStatus", SP_CODE, "The verification status to support the clinical status of the condition.", 0, Integer.MAX_VALUE, this.verificationStatus));
        childrenList.add(new Property(SP_SEVERITY, "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, Integer.MAX_VALUE, this.severity));
        childrenList.add(new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, Integer.MAX_VALUE, this.onset));
        childrenList.add(new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, Integer.MAX_VALUE, this.abatement));
        childrenList.add(new Property(SP_STAGE, "", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, Integer.MAX_VALUE, this.stage));
        childrenList.add(new Property(SP_EVIDENCE, "", "Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed.", 0, Integer.MAX_VALUE, this.evidence));
        childrenList.add(new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("notes", "string", "Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.", 0, Integer.MAX_VALUE, this.notes));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.encounter;
                }
                return baseArray;
            }
            case -373242253: {
                Base[] baseArray;
                if (this.asserter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.asserter;
                }
                return baseArray;
            }
            case 1888120446: {
                Base[] baseArray;
                if (this.dateRecorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.dateRecorded;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.category;
                }
                return baseArray;
            }
            case -462853915: {
                Base[] baseArray;
                if (this.clinicalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.clinicalStatus;
                }
                return baseArray;
            }
            case -842509843: {
                Base[] baseArray;
                if (this.verificationStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.verificationStatus;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.severity;
                }
                return baseArray;
            }
            case 105901603: {
                Base[] baseArray;
                if (this.onset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.onset;
                }
                return baseArray;
            }
            case -921554001: {
                Base[] baseArray;
                if (this.abatement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.abatement;
                }
                return baseArray;
            }
            case 109757182: {
                Base[] baseArray;
                if (this.stage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.stage;
                }
                return baseArray;
            }
            case 382967383: {
                return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case 105008833: {
                Base[] baseArray;
                if (this.notes == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.notes;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case -373242253: {
                this.asserter = this.castToReference(value);
                break;
            }
            case 1888120446: {
                this.dateRecorded = this.castToDate(value);
                break;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                break;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                break;
            }
            case -462853915: {
                this.clinicalStatus = this.castToCode(value);
                break;
            }
            case -842509843: {
                this.verificationStatus = new ConditionVerificationStatusEnumFactory().fromType(value);
                break;
            }
            case 1478300413: {
                this.severity = this.castToCodeableConcept(value);
                break;
            }
            case 105901603: {
                this.onset = (Type)value;
                break;
            }
            case -921554001: {
                this.abatement = (Type)value;
                break;
            }
            case 109757182: {
                this.stage = (ConditionStageComponent)value;
                break;
            }
            case 382967383: {
                this.getEvidence().add((ConditionEvidenceComponent)value);
                break;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                break;
            }
            case 105008833: {
                this.notes = this.castToString(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_ASSERTER)) {
            this.asserter = this.castToReference(value);
        } else if (name.equals("dateRecorded")) {
            this.dateRecorded = this.castToDate(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("clinicalStatus")) {
            this.clinicalStatus = this.castToCode(value);
        } else if (name.equals("verificationStatus")) {
            this.verificationStatus = new ConditionVerificationStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_SEVERITY)) {
            this.severity = this.castToCodeableConcept(value);
        } else if (name.equals("onset[x]")) {
            this.onset = (Type)value;
        } else if (name.equals("abatement[x]")) {
            this.abatement = (Type)value;
        } else if (name.equals(SP_STAGE)) {
            this.stage = (ConditionStageComponent)value;
        } else if (name.equals(SP_EVIDENCE)) {
            this.getEvidence().add((ConditionEvidenceComponent)value);
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("notes")) {
            this.notes = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -373242253: {
                return this.getAsserter();
            }
            case 1888120446: {
                throw new FHIRException("Cannot make property dateRecorded as it is not a complex type");
            }
            case 3059181: {
                return this.getCode();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -462853915: {
                throw new FHIRException("Cannot make property clinicalStatus as it is not a complex type");
            }
            case -842509843: {
                throw new FHIRException("Cannot make property verificationStatus as it is not a complex type");
            }
            case 1478300413: {
                return this.getSeverity();
            }
            case -1886216323: {
                return this.getOnset();
            }
            case -584196495: {
                return this.getAbatement();
            }
            case 109757182: {
                return this.getStage();
            }
            case 382967383: {
                return this.addEvidence();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case 105008833: {
                throw new FHIRException("Cannot make property notes as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_ASSERTER)) {
            this.asserter = new Reference();
            return this.asserter;
        }
        if (name.equals("dateRecorded")) {
            throw new FHIRException("Cannot call addChild on a singleton property Condition.dateRecorded");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("clinicalStatus")) {
            throw new FHIRException("Cannot call addChild on a singleton property Condition.clinicalStatus");
        }
        if (name.equals("verificationStatus")) {
            throw new FHIRException("Cannot call addChild on a singleton property Condition.verificationStatus");
        }
        if (name.equals(SP_SEVERITY)) {
            this.severity = new CodeableConcept();
            return this.severity;
        }
        if (name.equals("onsetDateTime")) {
            this.onset = new DateTimeType();
            return this.onset;
        }
        if (name.equals("onsetAge")) {
            this.onset = new Age();
            return this.onset;
        }
        if (name.equals("onsetPeriod")) {
            this.onset = new Period();
            return this.onset;
        }
        if (name.equals("onsetRange")) {
            this.onset = new Range();
            return this.onset;
        }
        if (name.equals("onsetString")) {
            this.onset = new StringType();
            return this.onset;
        }
        if (name.equals("abatementDateTime")) {
            this.abatement = new DateTimeType();
            return this.abatement;
        }
        if (name.equals("abatementAge")) {
            this.abatement = new Age();
            return this.abatement;
        }
        if (name.equals("abatementBoolean")) {
            this.abatement = new BooleanType();
            return this.abatement;
        }
        if (name.equals("abatementPeriod")) {
            this.abatement = new Period();
            return this.abatement;
        }
        if (name.equals("abatementRange")) {
            this.abatement = new Range();
            return this.abatement;
        }
        if (name.equals("abatementString")) {
            this.abatement = new StringType();
            return this.abatement;
        }
        if (name.equals(SP_STAGE)) {
            this.stage = new ConditionStageComponent();
            return this.stage;
        }
        if (name.equals(SP_EVIDENCE)) {
            return this.addEvidence();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("notes")) {
            throw new FHIRException("Cannot call addChild on a singleton property Condition.notes");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Condition";
    }

    @Override
    public Condition copy() {
        Condition dst = new Condition();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.asserter = this.asserter == null ? null : this.asserter.copy();
        dst.dateRecorded = this.dateRecorded == null ? null : this.dateRecorded.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.clinicalStatus = this.clinicalStatus == null ? null : this.clinicalStatus.copy();
        dst.verificationStatus = this.verificationStatus == null ? null : this.verificationStatus.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.onset = this.onset == null ? null : this.onset.copy();
        dst.abatement = this.abatement == null ? null : this.abatement.copy();
        ConditionStageComponent conditionStageComponent = dst.stage = this.stage == null ? null : this.stage.copy();
        if (this.evidence != null) {
            dst.evidence = new ArrayList<ConditionEvidenceComponent>();
            for (ConditionEvidenceComponent conditionEvidenceComponent : this.evidence) {
                dst.evidence.add(conditionEvidenceComponent.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodySite) {
                dst.bodySite.add(codeableConcept.copy());
            }
        }
        dst.notes = this.notes == null ? null : this.notes.copy();
        return dst;
    }

    protected Condition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other;
        return Condition.compareDeep(this.identifier, o.identifier, true) && Condition.compareDeep(this.patient, o.patient, true) && Condition.compareDeep(this.encounter, o.encounter, true) && Condition.compareDeep(this.asserter, o.asserter, true) && Condition.compareDeep(this.dateRecorded, o.dateRecorded, true) && Condition.compareDeep(this.code, o.code, true) && Condition.compareDeep(this.category, o.category, true) && Condition.compareDeep(this.clinicalStatus, o.clinicalStatus, true) && Condition.compareDeep(this.verificationStatus, o.verificationStatus, true) && Condition.compareDeep(this.severity, o.severity, true) && Condition.compareDeep(this.onset, o.onset, true) && Condition.compareDeep(this.abatement, o.abatement, true) && Condition.compareDeep(this.stage, o.stage, true) && Condition.compareDeep(this.evidence, o.evidence, true) && Condition.compareDeep(this.bodySite, o.bodySite, true) && Condition.compareDeep(this.notes, o.notes, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other;
        return Condition.compareValues(this.dateRecorded, o.dateRecorded, true) && Condition.compareValues(this.clinicalStatus, o.clinicalStatus, true) && Condition.compareValues(this.verificationStatus, o.verificationStatus, true) && Condition.compareValues(this.notes, o.notes, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.asserter != null && !this.asserter.isEmpty() || this.dateRecorded != null && !this.dateRecorded.isEmpty() || this.code != null && !this.code.isEmpty() || this.category != null && !this.category.isEmpty() || this.clinicalStatus != null && !this.clinicalStatus.isEmpty() || this.verificationStatus != null && !this.verificationStatus.isEmpty() || this.severity != null && !this.severity.isEmpty() || this.onset != null && !this.onset.isEmpty() || this.abatement != null && !this.abatement.isEmpty() || this.stage != null && !this.stage.isEmpty() || this.evidence != null && !this.evidence.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.notes != null && !this.notes.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Condition;
    }

    public static class ConditionVerificationStatusEnumFactory
    implements EnumFactory<ConditionVerificationStatus> {
        @Override
        public ConditionVerificationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("provisional".equals(codeString)) {
                return ConditionVerificationStatus.PROVISIONAL;
            }
            if ("differential".equals(codeString)) {
                return ConditionVerificationStatus.DIFFERENTIAL;
            }
            if ("confirmed".equals(codeString)) {
                return ConditionVerificationStatus.CONFIRMED;
            }
            if ("refuted".equals(codeString)) {
                return ConditionVerificationStatus.REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ConditionVerificationStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ConditionVerificationStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ConditionVerificationStatus code '" + codeString + "'");
        }

        public Enumeration<ConditionVerificationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provisional".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.PROVISIONAL);
            }
            if ("differential".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.DIFFERENTIAL);
            }
            if ("confirmed".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.CONFIRMED);
            }
            if ("refuted".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.REFUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ConditionVerificationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionVerificationStatus code) {
            if (code == ConditionVerificationStatus.NULL) {
                return null;
            }
            if (code == ConditionVerificationStatus.PROVISIONAL) {
                return "provisional";
            }
            if (code == ConditionVerificationStatus.DIFFERENTIAL) {
                return "differential";
            }
            if (code == ConditionVerificationStatus.CONFIRMED) {
                return "confirmed";
            }
            if (code == ConditionVerificationStatus.REFUTED) {
                return "refuted";
            }
            if (code == ConditionVerificationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ConditionVerificationStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionVerificationStatus code) {
            return code.getSystem();
        }
    }

    public static enum ConditionVerificationStatus {
        PROVISIONAL,
        DIFFERENTIAL,
        CONFIRMED,
        REFUTED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ConditionVerificationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provisional".equals(codeString)) {
                return PROVISIONAL;
            }
            if ("differential".equals(codeString)) {
                return DIFFERENTIAL;
            }
            if ("confirmed".equals(codeString)) {
                return CONFIRMED;
            }
            if ("refuted".equals(codeString)) {
                return REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            throw new FHIRException("Unknown ConditionVerificationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROVISIONAL: {
                    return "provisional";
                }
                case DIFFERENTIAL: {
                    return "differential";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case REFUTED: {
                    return "refuted";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROVISIONAL: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case DIFFERENTIAL: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case CONFIRMED: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case REFUTED: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROVISIONAL: {
                    return "This is a tentative diagnosis - still a candidate that is under consideration.";
                }
                case DIFFERENTIAL: {
                    return "One of a set of potential (and typically mutually exclusive) diagnosis asserted to further guide the diagnostic process and preliminary treatment.";
                }
                case CONFIRMED: {
                    return "There is sufficient diagnostic and/or clinical evidence to treat this as a confirmed condition.";
                }
                case REFUTED: {
                    return "This condition has been ruled out by diagnostic and clinical evidence.";
                }
                case ENTEREDINERROR: {
                    return "The statement was entered in error and is not valid.";
                }
                case UNKNOWN: {
                    return "The condition status is unknown.  Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROVISIONAL: {
                    return "Provisional";
                }
                case DIFFERENTIAL: {
                    return "Differential";
                }
                case CONFIRMED: {
                    return "Confirmed";
                }
                case REFUTED: {
                    return "Refuted";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ConditionStageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="summary", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Simple summary (disease specific)", formalDefinition="A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific.")
        protected CodeableConcept summary;
        @Child(name="assessment", type={ClinicalImpression.class, DiagnosticReport.class, Observation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Formal record of assessment", formalDefinition="Reference to a formal record of the evidence on which the staging assessment is based.")
        protected List<Reference> assessment;
        protected List<Resource> assessmentTarget;
        private static final long serialVersionUID = -1961530405L;

        public CodeableConcept getSummary() {
            if (this.summary == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionStageComponent.summary");
                }
                if (Configuration.doAutoCreate()) {
                    this.summary = new CodeableConcept();
                }
            }
            return this.summary;
        }

        public boolean hasSummary() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public ConditionStageComponent setSummary(CodeableConcept value) {
            this.summary = value;
            return this;
        }

        public List<Reference> getAssessment() {
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            return this.assessment;
        }

        public boolean hasAssessment() {
            if (this.assessment == null) {
                return false;
            }
            for (Reference item : this.assessment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAssessment() {
            Reference t = new Reference();
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            this.assessment.add(t);
            return t;
        }

        public ConditionStageComponent addAssessment(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            this.assessment.add(t);
            return this;
        }

        public List<Resource> getAssessmentTarget() {
            if (this.assessmentTarget == null) {
                this.assessmentTarget = new ArrayList<Resource>();
            }
            return this.assessmentTarget;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("summary", "CodeableConcept", "A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific.", 0, Integer.MAX_VALUE, this.summary));
            childrenList.add(new Property("assessment", "Reference(ClinicalImpression|DiagnosticReport|Observation)", "Reference to a formal record of the evidence on which the staging assessment is based.", 0, Integer.MAX_VALUE, this.assessment));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    Base[] baseArray;
                    if (this.summary == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.summary;
                    }
                    return baseArray;
                }
                case 2119382722: {
                    return this.assessment == null ? new Base[]{} : this.assessment.toArray(new Base[this.assessment.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    this.summary = this.castToCodeableConcept(value);
                    break;
                }
                case 2119382722: {
                    this.getAssessment().add(this.castToReference(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("summary")) {
                this.summary = this.castToCodeableConcept(value);
            } else if (name.equals("assessment")) {
                this.getAssessment().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    return this.getSummary();
                }
                case 2119382722: {
                    return this.addAssessment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("summary")) {
                this.summary = new CodeableConcept();
                return this.summary;
            }
            if (name.equals("assessment")) {
                return this.addAssessment();
            }
            return super.addChild(name);
        }

        @Override
        public ConditionStageComponent copy() {
            ConditionStageComponent dst = new ConditionStageComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.summary = this.summary == null ? null : this.summary.copy();
            if (this.assessment != null) {
                dst.assessment = new ArrayList<Reference>();
                for (Reference i : this.assessment) {
                    dst.assessment.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConditionStageComponent)) {
                return false;
            }
            ConditionStageComponent o = (ConditionStageComponent)other;
            return ConditionStageComponent.compareDeep(this.summary, o.summary, true) && ConditionStageComponent.compareDeep(this.assessment, o.assessment, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConditionStageComponent)) {
                return false;
            }
            ConditionStageComponent o = (ConditionStageComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.summary != null && !this.summary.isEmpty() || this.assessment != null && !this.assessment.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Condition.stage";
        }
    }

    @Block
    public static class ConditionEvidenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Manifestation/symptom", formalDefinition="A manifestation or symptom that led to the recording of this condition.")
        protected CodeableConcept code;
        @Child(name="detail", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting information found elsewhere", formalDefinition="Links to other relevant information, including pathology reports.")
        protected List<Reference> detail;
        protected List<Resource> detailTarget;
        private static final long serialVersionUID = 945689926L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionEvidenceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionEvidenceComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public ConditionEvidenceComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public List<Resource> getDetailTarget() {
            if (this.detailTarget == null) {
                this.detailTarget = new ArrayList<Resource>();
            }
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Condition.SP_CODE, "CodeableConcept", "A manifestation or symptom that led to the recording of this condition.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("detail", "Reference(Any)", "Links to other relevant information, including pathology reports.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case -1335224239: {
                    this.getDetail().add(this.castToReference(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Condition.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("detail")) {
                this.getDetail().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Condition.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ConditionEvidenceComponent copy() {
            ConditionEvidenceComponent dst = new ConditionEvidenceComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference i : this.detail) {
                    dst.detail.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConditionEvidenceComponent)) {
                return false;
            }
            ConditionEvidenceComponent o = (ConditionEvidenceComponent)other;
            return ConditionEvidenceComponent.compareDeep(this.code, o.code, true) && ConditionEvidenceComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConditionEvidenceComponent)) {
                return false;
            }
            ConditionEvidenceComponent o = (ConditionEvidenceComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Condition.evidence";
        }
    }
}

